/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzParam;
import org.rdlinux.ezmybatis.core.EzQuery;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.SqlStruct;
import org.rdlinux.ezmybatis.core.sqlstruct.order.ColumnOrderItem;
import org.rdlinux.ezmybatis.core.sqlstruct.order.FieldOrderItem;
import org.rdlinux.ezmybatis.core.sqlstruct.order.OrderItem;
import org.rdlinux.ezmybatis.core.sqlstruct.order.OrderType;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EntityTable;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;
import org.rdlinux.ezmybatis.utils.DbTypeUtils;

public class OrderBy
implements SqlStruct {
    private static final Map<DbType, SqlStruct> CONVERT = new HashMap<DbType, SqlStruct>();
    private List<OrderItem> items;

    public OrderBy(List<OrderItem> items) {
        this.items = items;
    }

    private static StringBuilder defaultOrderByToSql(StringBuilder sqlBuilder, Configuration configuration, EzQuery<?> ezParam) {
        OrderBy order = ezParam.getOrderBy();
        if (order == null || order.getItems() == null) {
            return sqlBuilder;
        }
        StringBuilder sql = new StringBuilder(" ORDER BY ");
        for (int i = 0; i < order.getItems().size(); ++i) {
            OrderItem orderItem = order.getItems().get(i);
            sql.append(orderItem.toSqlStruct(configuration));
            if (i + 1 < order.getItems().size()) {
                sql.append(", ");
                continue;
            }
            sql.append(" ");
        }
        return sqlBuilder.append((CharSequence)sql);
    }

    @Override
    public StringBuilder toSqlPart(StringBuilder sqlBuilder, Configuration configuration, EzParam<?> ezParam, MybatisParamHolder mybatisParamHolder) {
        return CONVERT.get((Object)DbTypeUtils.getDbType(configuration)).toSqlPart(sqlBuilder, configuration, ezParam, mybatisParamHolder);
    }

    public List<OrderItem> getItems() {
        return this.items;
    }

    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    static {
        SqlStruct defaultConvert = (sqlBuilder, configuration, ezParam, mybatisParamHolder) -> OrderBy.defaultOrderByToSql(sqlBuilder, configuration, (EzQuery)ezParam);
        CONVERT.put(DbType.MYSQL, defaultConvert);
        CONVERT.put(DbType.ORACLE, defaultConvert);
        CONVERT.put(DbType.DM, defaultConvert);
    }

    public static class OrderBuilder<T> {
        private T target;
        private Table table;
        private OrderBy orderBy;

        public OrderBuilder(T target, OrderBy orderBy, Table table) {
            this.target = target;
            this.orderBy = orderBy;
            this.table = table;
        }

        private void checkEntityTable() {
            if (!(this.table instanceof EntityTable)) {
                throw new IllegalArgumentException("Only EntityTable is supported");
            }
        }

        @Deprecated
        public OrderBuilder<T> add(String field) {
            return this.addField(field);
        }

        public OrderBuilder<T> addField(String field) {
            this.checkEntityTable();
            this.orderBy.getItems().add(new FieldOrderItem((EntityTable)this.table, field));
            return this;
        }

        @Deprecated
        public OrderBuilder<T> add(boolean sure, String field) {
            return this.addField(sure, field);
        }

        public OrderBuilder<T> addField(boolean sure, String field) {
            if (sure) {
                this.addField(field);
            }
            return this;
        }

        public OrderBuilder<T> addColumn(String column) {
            this.orderBy.getItems().add(new ColumnOrderItem(this.table, column));
            return this;
        }

        public OrderBuilder<T> addColumn(boolean sure, String column) {
            if (sure) {
                return this.addColumn(column);
            }
            return this;
        }

        @Deprecated
        public OrderBuilder<T> add(String field, OrderType type) {
            return this.addField(field, type);
        }

        public OrderBuilder<T> addField(String field, OrderType type) {
            this.checkEntityTable();
            this.orderBy.getItems().add(new FieldOrderItem((EntityTable)this.table, field, type));
            return this;
        }

        @Deprecated
        public OrderBuilder<T> add(boolean sure, String field, OrderType type) {
            return this.addField(sure, field, type);
        }

        public OrderBuilder<T> addField(boolean sure, String field, OrderType type) {
            if (sure) {
                this.addField(field, type);
            }
            return this;
        }

        public OrderBuilder<T> addColumn(String column, OrderType type) {
            this.orderBy.getItems().add(new ColumnOrderItem(this.table, column, type));
            return this;
        }

        public OrderBuilder<T> addColumn(boolean sure, String column, OrderType type) {
            if (sure) {
                return this.addColumn(column, type);
            }
            return this;
        }

        public T done() {
            return this.target;
        }
    }
}

