/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.condition.compare;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Operator;

public class AliasCompareCondition
implements Condition {
    private Condition.LogicalOperator logicalOperator;
    private String leftAlias;
    private Operator operator;
    private String rightAlias;

    public AliasCompareCondition(String leftAlias, Operator operator, String rightAlias) {
        this.logicalOperator = Condition.LogicalOperator.AND;
        this.leftAlias = leftAlias;
        this.operator = operator;
        this.rightAlias = rightAlias;
    }

    public AliasCompareCondition(Condition.LogicalOperator logicalOperator, String leftAlias, Operator operator, String rightAlias) {
        this.logicalOperator = logicalOperator;
        this.leftAlias = leftAlias;
        this.operator = operator;
        this.rightAlias = rightAlias;
    }

    @Override
    public Condition.LogicalOperator getLogicalOperator() {
        return this.logicalOperator;
    }

    @Override
    public String toSqlPart(Configuration configuration, MybatisParamHolder mybatisParamHolder) {
        String keywordQM = EzMybatisContent.getKeywordQM(configuration);
        return " " + keywordQM + this.leftAlias + keywordQM + " " + this.getOperator().getOperator() + " " + keywordQM + this.rightAlias + keywordQM + " ";
    }

    public String getLeftAlias() {
        return this.leftAlias;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getRightAlias() {
        return this.rightAlias;
    }
}

