/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.condition.compare;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Operator;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;

public class ColumnCompareCondition
implements Condition {
    private Condition.LogicalOperator logicalOperator;
    private Table leftTable;
    private String leftColumn;
    private Operator operator;
    private Table rightTable;
    private String rightColumn;

    public ColumnCompareCondition(Table leftTable, String leftColumn, Operator operator, Table rightTable, String rightColumn) {
        this.logicalOperator = Condition.LogicalOperator.AND;
        this.leftTable = leftTable;
        this.leftColumn = leftColumn;
        this.operator = operator;
        this.rightTable = rightTable;
        this.rightColumn = rightColumn;
    }

    public ColumnCompareCondition(Condition.LogicalOperator logicalOperator, Table leftTable, String leftColumn, Operator operator, Table rightTable, String rightColumn) {
        this.logicalOperator = logicalOperator;
        this.leftTable = leftTable;
        this.leftColumn = leftColumn;
        this.operator = operator;
        this.rightTable = rightTable;
        this.rightColumn = rightColumn;
    }

    @Override
    public Condition.LogicalOperator getLogicalOperator() {
        return this.logicalOperator;
    }

    @Override
    public String toSqlPart(Configuration configuration, MybatisParamHolder mybatisParamHolder) {
        String keywordQM = EzMybatisContent.getKeywordQM(configuration);
        return " " + this.getLeftTable().getAlias() + "." + keywordQM + this.leftColumn + keywordQM + " " + this.getOperator().getOperator() + " " + this.getRightTable().getAlias() + "." + keywordQM + this.rightColumn + keywordQM + " ";
    }

    public Table getLeftTable() {
        return this.leftTable;
    }

    public String getLeftColumn() {
        return this.leftColumn;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Table getRightTable() {
        return this.rightTable;
    }

    public String getRightColumn() {
        return this.rightColumn;
    }
}

