/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HumpLineStringUtils {
    private static Pattern humpPattern = Pattern.compile("[A-Z]");

    public static String humpToLine(String str, String interval) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, interval + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        if (sb.indexOf(interval) == 0) {
            sb.delete(0, 1);
        }
        return sb.toString();
    }

    public static String humpToLine(String str) {
        return HumpLineStringUtils.humpToLine(str, "_");
    }

    public static String lineToHump(String str, String interval) {
        Pattern linePattern = Pattern.compile(interval + "(\\w)");
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String lineToHump(String str) {
        return HumpLineStringUtils.lineToHump(str, "_");
    }
}

