/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.classinfo.entityinfo;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.AbstractEntityClassInfo;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityFieldInfo;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityInfoBuildConfig;
import org.rdlinux.ezmybatis.utils.Assert;
import org.rdlinux.ezmybatis.utils.HumpLineStringUtils;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;
import org.rdlinux.ezmybatis.utils.SqlReflectionUtils;

public class DefaultEntityClassInfo
extends AbstractEntityClassInfo {
    public DefaultEntityClassInfo(Class<?> entityClass, EntityInfoBuildConfig buildConfig) {
        Assert.notNull(entityClass, "entityClass can not be null");
        this.tableName = HumpLineStringUtils.humpToLine(entityClass.getSimpleName());
        if (entityClass.isAnnotationPresent(Table.class)) {
            Table annotation = entityClass.getAnnotation(Table.class);
            String tn = annotation.name();
            if (StringUtils.isNotEmpty((CharSequence)tn)) {
                this.tableName = tn;
            }
            this.schema = annotation.schema();
        }
        this.entityClass = entityClass;
        this.fieldInfos = new LinkedList();
        this.columnMapFieldInfo = new HashMap((int)((double)this.fieldInfos.size() / 0.75) + 1);
        this.filedNameMapFieldInfo = new HashMap((int)((double)this.fieldInfos.size() / 0.75) + 1);
        List<Field> fields = SqlReflectionUtils.getSupportFields(entityClass);
        for (Field field : fields) {
            Method fieldGetMethod;
            try {
                fieldGetMethod = ReflectionUtils.getMethodOfFieldGet(entityClass, field);
            }
            catch (Exception e) {
                continue;
            }
            EntityFieldInfo fieldInfo2 = new EntityFieldInfo(field, fieldGetMethod, buildConfig);
            this.fieldInfos.add(fieldInfo2);
            if (!fieldInfo2.isPrimaryKey()) continue;
            this.primaryKeyInfo = fieldInfo2;
        }
        this.fieldInfos.forEach(fieldInfo -> {
            this.columnMapFieldInfo.put(fieldInfo.getColumnName(), fieldInfo);
            this.filedNameMapFieldInfo.put(fieldInfo.getFieldName(), fieldInfo);
        });
    }
}

