/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlgenerate;

import java.util.ArrayList;
import java.util.Map;
import org.rdlinux.ezmybatis.utils.Assert;

public class MybatisParamHolder {
    private static final int ARRAY_MAX_PARAM = 47427;
    private ArrayList<Object> currentArray;
    private int currentArrayIndex = -1;
    private Map<String, Object> mybatisParam;

    public MybatisParamHolder(Map<String, Object> mybatisParam) {
        Assert.notNull(mybatisParam, "mybatisParam can not be null");
        this.mybatisParam = mybatisParam;
        this.transposeArray();
    }

    private static String getEscapeChar(Object param) {
        if (param instanceof Number) {
            return "$";
        }
        return "#";
    }

    private void transposeArray() {
        this.currentArray = new ArrayList(10);
        ++this.currentArrayIndex;
        this.mybatisParam.put(this.getCurrentHashKeyName(), this.currentArray);
    }

    private String getCurrentHashKeyName() {
        return "mp_" + this.currentArrayIndex;
    }

    public <T> T get(String param) {
        return (T)this.mybatisParam.get(param);
    }

    public String getMybatisParamName(Object paramValue) {
        if (paramValue == null) {
            return "NULL";
        }
        if (this.currentArray.size() >= 47427) {
            this.transposeArray();
        }
        this.currentArray.add(paramValue);
        String escape = MybatisParamHolder.getEscapeChar(paramValue);
        String mybatisParamName = this.getCurrentHashKeyName() + "[" + (this.currentArray.size() - 1) + "]";
        return escape + "{" + mybatisParamName + "}";
    }
}

