/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct;

import java.util.LinkedList;
import java.util.List;
import org.rdlinux.ezmybatis.core.sqlstruct.SqlStruct;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.ConditionBuilder;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.GroupCondition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.LogicalOperator;
import org.rdlinux.ezmybatis.core.sqlstruct.join.JoinType;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;

public class Join
implements SqlStruct {
    private Table table;
    private JoinType joinType;
    private Table joinTable;
    private List<Condition> onConditions;
    private List<Join> joins;
    private boolean sure;

    public Join setTable(Table table) {
        this.table = table;
        return this;
    }

    public Join setJoinType(JoinType joinType) {
        this.joinType = joinType;
        return this;
    }

    public Join setJoinTable(Table joinTable) {
        this.joinTable = joinTable;
        return this;
    }

    public Join setOnConditions(List<Condition> onConditions) {
        this.onConditions = onConditions;
        return this;
    }

    public Join setJoins(List<Join> joins) {
        this.joins = joins;
        return this;
    }

    public Join setSure(boolean sure) {
        this.sure = sure;
        return this;
    }

    public Table getTable() {
        return this.table;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Table getJoinTable() {
        return this.joinTable;
    }

    public List<Condition> getOnConditions() {
        return this.onConditions;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public boolean isSure() {
        return this.sure;
    }

    public static class JoinBuilder<Builder>
    extends ConditionBuilder<Builder, JoinBuilder<Builder>> {
        private Join join;

        public JoinBuilder(Builder builder, Join join) {
            super(builder, join.getOnConditions(), join.getTable(), join.getJoinTable());
            this.sonBuilder = this;
            this.join = join;
        }

        public JoinBuilder<JoinBuilder<Builder>> groupCondition(boolean sure, LogicalOperator logicalOperator) {
            GroupCondition condition = new GroupCondition(sure, new LinkedList<Condition>(), logicalOperator);
            this.conditions.add(condition);
            Join newJoin = new Join();
            newJoin.setTable(this.join.getTable());
            newJoin.setJoinTable(this.join.getJoinTable());
            newJoin.setOnConditions(condition.getConditions());
            return new JoinBuilder<JoinBuilder<Builder>>(this, newJoin);
        }

        public JoinBuilder<JoinBuilder<Builder>> groupCondition(LogicalOperator logicalOperator) {
            return this.groupCondition(true, logicalOperator);
        }

        public JoinBuilder<JoinBuilder<Builder>> groupCondition() {
            return this.groupCondition(LogicalOperator.AND);
        }

        public JoinBuilder<JoinBuilder<Builder>> groupCondition(boolean sure) {
            return this.groupCondition(sure, LogicalOperator.AND);
        }

        public JoinBuilder<JoinBuilder<Builder>> join(boolean sure, JoinType joinType, Table joinTable) {
            if (this.join.getJoins() == null) {
                this.join.joins = new LinkedList();
            }
            Join newJoin = new Join();
            newJoin.setJoinType(joinType);
            newJoin.setTable(this.join.getJoinTable());
            newJoin.setJoinTable(joinTable);
            newJoin.setOnConditions(new LinkedList<Condition>());
            newJoin.setSure(sure);
            this.join.joins.add(newJoin);
            return new JoinBuilder<JoinBuilder<Builder>>(this, newJoin);
        }

        public JoinBuilder<JoinBuilder<Builder>> join(JoinType joinType, Table joinTable) {
            return this.join(true, joinType, joinTable);
        }

        public JoinBuilder<JoinBuilder<Builder>> join(Table joinTable) {
            return this.join(JoinType.InnerJoin, joinTable);
        }

        public JoinBuilder<JoinBuilder<Builder>> join(boolean sure, Table joinTable) {
            return this.join(sure, JoinType.InnerJoin, joinTable);
        }

        public JoinBuilder<Builder> joinTableCondition() {
            this.table = this.join.getJoinTable();
            this.otherTable = this.join.getTable();
            return this;
        }

        public JoinBuilder<Builder> masterTableCondition() {
            this.table = this.join.getTable();
            this.otherTable = this.join.getJoinTable();
            return this;
        }
    }
}

