/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.between.BetweenAliasCondition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.between.BetweenCondition;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;

public class MySqlBetweenAliasConditionConverter
extends AbstractConverter<BetweenAliasCondition>
implements Converter<BetweenAliasCondition> {
    private static volatile MySqlBetweenAliasConditionConverter instance;

    protected MySqlBetweenAliasConditionConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlBetweenAliasConditionConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlBetweenAliasConditionConverter> clazz = MySqlBetweenAliasConditionConverter.class;
        synchronized (MySqlBetweenAliasConditionConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlBetweenAliasConditionConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected static StringBuilder doBuildSql(StringBuilder sqlBuilder, Configuration configuration, BetweenCondition obj, MybatisParamHolder mybatisParamHolder, String column) {
        if (obj.getMinValue() == null || obj.getMaxValue() == null) {
            return sqlBuilder;
        }
        String sql = " " + column + " " + obj.getOperator().getOperator() + " " + Condition.valueToSqlStruct(configuration, mybatisParamHolder, obj.getMinValue()) + " AND " + Condition.valueToSqlStruct(configuration, mybatisParamHolder, obj.getMaxValue()) + " ";
        return sqlBuilder.append(sql);
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, BetweenAliasCondition obj, MybatisParamHolder mybatisParamHolder) {
        String keywordQM = EzMybatisContent.getKeywordQM(configuration);
        String column = " " + keywordQM + obj.getAlias() + keywordQM + " ";
        return MySqlBetweenAliasConditionConverter.doBuildSql(sqlBuilder, configuration, obj, mybatisParamHolder, column);
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

