/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.classinfo.EzEntityClassInfoFactory;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.selectitem.SelectField;

public class MySqlSelectFieldConverter
extends AbstractConverter<SelectField>
implements Converter<SelectField> {
    private static volatile MySqlSelectFieldConverter instance;

    protected MySqlSelectFieldConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlSelectFieldConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlSelectFieldConverter> clazz = MySqlSelectFieldConverter.class;
        synchronized (MySqlSelectFieldConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlSelectFieldConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, SelectField ojb, MybatisParamHolder mybatisParamHolder) {
        EntityClassInfo entityClassInfo = EzEntityClassInfoFactory.forClass(configuration, ojb.getTable().getEtType());
        String keywordQM = EzMybatisContent.getKeywordQM(configuration);
        String columnName = keywordQM + entityClassInfo.getFieldInfo(ojb.getField()).getColumnName() + keywordQM;
        String sql = " " + ojb.getTable().getAlias() + "." + columnName + " ";
        String alias = ojb.getAlias();
        if (alias != null && !alias.isEmpty()) {
            sql = sql + keywordQM + alias + keywordQM + " ";
        }
        return sqlBuilder.append(sql);
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

