/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.oracle;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzQuery;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.Alias;
import org.rdlinux.ezmybatis.core.sqlstruct.GroupBy;
import org.rdlinux.ezmybatis.core.sqlstruct.Limit;
import org.rdlinux.ezmybatis.core.sqlstruct.OrderBy;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;

public class OracleLimitConverter
extends AbstractConverter<Limit>
implements Converter<Limit> {
    public static final String ROW_NUM_ALIAS = "ORA_ROWNUM";
    private static volatile OracleLimitConverter instance;

    protected OracleLimitConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OracleLimitConverter getInstance() {
        if (instance != null) return instance;
        Class<OracleLimitConverter> clazz = OracleLimitConverter.class;
        synchronized (OracleLimitConverter.class) {
            if (instance != null) return instance;
            instance = new OracleLimitConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, Limit limit, MybatisParamHolder mybatisParamHolder) {
        if (limit == null) {
            return sqlBuilder;
        }
        GroupBy groupBy = null;
        OrderBy orderBy = null;
        EzQuery<?> query = limit.getQuery();
        if (query != null) {
            groupBy = query.getGroupBy();
            orderBy = query.getOrderBy();
        }
        if ((groupBy == null || groupBy.getItems() == null || groupBy.getItems().isEmpty()) && (orderBy == null || orderBy.getItems() == null || orderBy.getItems().isEmpty())) {
            String bodyAlias = Alias.getAlias();
            return new StringBuilder("SELECT ").append(bodyAlias).append(".* ").append(" FROM ( ").append((CharSequence)sqlBuilder).append(" ) ").append(bodyAlias).append(" WHERE ").append(bodyAlias).append(".").append(ROW_NUM_ALIAS).append(" > ").append(limit.getSkip());
        }
        String bodyAlias = Alias.getAlias();
        String outSqlBody = "SELECT " + bodyAlias + ".*, ROWNUM " + ROW_NUM_ALIAS + " FROM (" + sqlBuilder + ") " + bodyAlias + " WHERE ROWNUM <= " + (limit.getSkip() + limit.getSize()) + " ";
        String outAlias = Alias.getAlias();
        String outSqlHead = "SELECT " + outAlias + ".* FROM ( ";
        String outSqlTail = " ) " + outAlias + " WHERE " + outAlias + "." + ROW_NUM_ALIAS + " > " + limit.getSkip();
        return new StringBuilder().append(outSqlHead).append(outSqlBody).append(outSqlTail);
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.ORACLE;
    }
}

