/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.oracle;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.table.partition.SubPartition;

public class OracleSubPartitionConverter
extends AbstractConverter<SubPartition>
implements Converter<SubPartition> {
    private static volatile OracleSubPartitionConverter instance;

    protected OracleSubPartitionConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OracleSubPartitionConverter getInstance() {
        if (instance != null) return instance;
        Class<OracleSubPartitionConverter> clazz = OracleSubPartitionConverter.class;
        synchronized (OracleSubPartitionConverter.class) {
            if (instance != null) return instance;
            instance = new OracleSubPartitionConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, SubPartition partition, MybatisParamHolder mybatisParamHolder) {
        if (partition == null || partition.getPartitions() == null || partition.getPartitions().isEmpty()) {
            return sqlBuilder;
        }
        return sqlBuilder.append(" SUBPARTITION(").append(partition.getPartitions().get(0)).append(") ");
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

