/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.formula;

import java.util.LinkedList;
import java.util.List;
import org.rdlinux.ezmybatis.core.sqlstruct.Function;
import org.rdlinux.ezmybatis.core.sqlstruct.SqlStruct;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.ColumnFormulaElement;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.FieldFormulaElement;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.FormulaElement;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.FormulaFormulaElement;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.FunFormulaElement;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.GroupFormulaElement;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.KeywordsFormulaElement;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.Operator;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.ValueFormulaElement;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EntityTable;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;

public class Formula
implements SqlStruct {
    private Table table;
    private List<FormulaElement> elements;

    private Formula() {
    }

    public static FormulaEleBuilder<FormulaBuilder> builder(Table table) {
        LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
        FormulaBuilder formulaBuilder = new FormulaBuilder(table, elements);
        return new FormulaEleBuilder<FormulaBuilder>(formulaBuilder, table, elements);
    }

    public Table getTable() {
        return this.table;
    }

    public List<FormulaElement> getElements() {
        return this.elements;
    }

    public static class FormulaEleBuilder<ParentBuilder> {
        protected ParentBuilder parentBuilder;
        protected List<FormulaElement> elements;
        protected Table table;

        public FormulaEleBuilder(ParentBuilder parentBuilder, Table table, List<FormulaElement> elements) {
            this.parentBuilder = parentBuilder;
            this.table = table;
            this.elements = elements;
        }

        public ParentBuilder done() {
            return this.parentBuilder;
        }

        private void checkEntityTable() {
            if (!(this.table instanceof EntityTable)) {
                throw new IllegalArgumentException("Only EntityTable is supported");
            }
        }

        public FormulaEleBuilder<ParentBuilder> withColumn(Table table, String column) {
            ColumnFormulaElement element = new ColumnFormulaElement(Operator.EMPTY, table, column);
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> withColumn(String column) {
            return this.withColumn(this.table, column);
        }

        public FormulaEleBuilder<ParentBuilder> withField(EntityTable table, String field) {
            FieldFormulaElement element = new FieldFormulaElement(Operator.EMPTY, table, field);
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> withField(String field) {
            this.checkEntityTable();
            return this.withField((EntityTable)this.table, field);
        }

        public FormulaEleBuilder<ParentBuilder> withFun(Function fun) {
            FunFormulaElement element = new FunFormulaElement(Operator.EMPTY, fun);
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> withValue(Object ojb) {
            ValueFormulaElement element = new ValueFormulaElement(Operator.EMPTY, ojb);
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> withFormula(Formula formula) {
            FormulaFormulaElement element = new FormulaFormulaElement(Operator.EMPTY, formula);
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> withKeywords(String keywords) {
            KeywordsFormulaElement element = new KeywordsFormulaElement(Operator.EMPTY, keywords);
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>> withGroup() {
            LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
            GroupFormulaElement element = new GroupFormulaElement(Operator.EMPTY, elements);
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return new FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>>(this, this.table, elements);
        }

        public FormulaEleBuilder<ParentBuilder> addColumn(Table table, String column) {
            ColumnFormulaElement element = new ColumnFormulaElement(Operator.ADD, table, column);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> addColumn(String column) {
            return this.addColumn(this.table, column);
        }

        public FormulaEleBuilder<ParentBuilder> addField(EntityTable table, String field) {
            FieldFormulaElement element = new FieldFormulaElement(Operator.ADD, table, field);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> addField(String field) {
            this.checkEntityTable();
            return this.addField((EntityTable)this.table, field);
        }

        public FormulaEleBuilder<ParentBuilder> addFun(Function fun) {
            FunFormulaElement element = new FunFormulaElement(Operator.ADD, fun);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> addValue(Object ojb) {
            ValueFormulaElement element = new ValueFormulaElement(Operator.ADD, ojb);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> addFormula(Formula formula) {
            FormulaFormulaElement element = new FormulaFormulaElement(Operator.ADD, formula);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> addKeywords(String keywords) {
            KeywordsFormulaElement element = new KeywordsFormulaElement(Operator.ADD, keywords);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>> addGroup() {
            LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
            GroupFormulaElement element = new GroupFormulaElement(Operator.ADD, elements);
            this.elements.add(element);
            return new FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>>(this, this.table, elements);
        }

        public FormulaEleBuilder<ParentBuilder> subtractColumn(Table table, String column) {
            ColumnFormulaElement element = new ColumnFormulaElement(Operator.SUBTRACT, table, column);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> subtractColumn(String column) {
            return this.subtractColumn(this.table, column);
        }

        public FormulaEleBuilder<ParentBuilder> subtractField(EntityTable table, String field) {
            FieldFormulaElement element = new FieldFormulaElement(Operator.SUBTRACT, table, field);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> subtractField(String field) {
            this.checkEntityTable();
            return this.subtractField((EntityTable)this.table, field);
        }

        public FormulaEleBuilder<ParentBuilder> subtractFun(Function fun) {
            FunFormulaElement element = new FunFormulaElement(Operator.SUBTRACT, fun);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> subtractValue(Object ojb) {
            ValueFormulaElement element = new ValueFormulaElement(Operator.SUBTRACT, ojb);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> subtractFormula(Formula formula) {
            FormulaFormulaElement element = new FormulaFormulaElement(Operator.SUBTRACT, formula);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> subtractKeywords(String keywords) {
            KeywordsFormulaElement element = new KeywordsFormulaElement(Operator.SUBTRACT, keywords);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>> subtractGroup() {
            LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
            GroupFormulaElement element = new GroupFormulaElement(Operator.SUBTRACT, elements);
            this.elements.add(element);
            return new FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>>(this, this.table, elements);
        }

        public FormulaEleBuilder<ParentBuilder> multiplyColumn(Table table, String column) {
            ColumnFormulaElement element = new ColumnFormulaElement(Operator.MULTIPLY, table, column);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> multiplyColumn(String column) {
            return this.multiplyColumn(this.table, column);
        }

        public FormulaEleBuilder<ParentBuilder> multiplyField(EntityTable table, String field) {
            FieldFormulaElement element = new FieldFormulaElement(Operator.MULTIPLY, table, field);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> multiplyField(String field) {
            this.checkEntityTable();
            return this.multiplyField((EntityTable)this.table, field);
        }

        public FormulaEleBuilder<ParentBuilder> multiplyFun(Function fun) {
            FunFormulaElement element = new FunFormulaElement(Operator.MULTIPLY, fun);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> multiplyValue(Object ojb) {
            ValueFormulaElement element = new ValueFormulaElement(Operator.MULTIPLY, ojb);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> multiplyFormula(Formula formula) {
            FormulaFormulaElement element = new FormulaFormulaElement(Operator.MULTIPLY, formula);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> multiplyKeywords(String keywords) {
            KeywordsFormulaElement element = new KeywordsFormulaElement(Operator.MULTIPLY, keywords);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>> multiplyGroup() {
            LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
            GroupFormulaElement element = new GroupFormulaElement(Operator.MULTIPLY, elements);
            this.elements.add(element);
            return new FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>>(this, this.table, elements);
        }

        public FormulaEleBuilder<ParentBuilder> divideColumn(Table table, String column) {
            ColumnFormulaElement element = new ColumnFormulaElement(Operator.DIVIDE, table, column);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> divideColumn(String column) {
            return this.divideColumn(this.table, column);
        }

        public FormulaEleBuilder<ParentBuilder> divideField(EntityTable table, String field) {
            FieldFormulaElement element = new FieldFormulaElement(Operator.DIVIDE, table, field);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> divideField(String field) {
            this.checkEntityTable();
            return this.divideField((EntityTable)this.table, field);
        }

        public FormulaEleBuilder<ParentBuilder> divideFun(Function fun) {
            FunFormulaElement element = new FunFormulaElement(Operator.DIVIDE, fun);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> divideValue(Object ojb) {
            ValueFormulaElement element = new ValueFormulaElement(Operator.DIVIDE, ojb);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> divideFormula(Formula formula) {
            FormulaFormulaElement element = new FormulaFormulaElement(Operator.DIVIDE, formula);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> divideKeywords(String keywords) {
            KeywordsFormulaElement element = new KeywordsFormulaElement(Operator.DIVIDE, keywords);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>> divideGroup() {
            LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
            GroupFormulaElement element = new GroupFormulaElement(Operator.DIVIDE, elements);
            this.elements.add(element);
            return new FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>>(this, this.table, elements);
        }
    }

    public static class FormulaBuilder {
        private Formula formula = new Formula();

        public FormulaBuilder(Table table, List<FormulaElement> elements) {
            this.formula.table = table;
            this.formula.elements = elements;
        }

        public Formula build() {
            return this.formula;
        }
    }
}

