/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct;

import java.util.LinkedList;
import java.util.List;
import org.rdlinux.ezmybatis.core.sqlstruct.ArgType;
import org.rdlinux.ezmybatis.core.sqlstruct.CaseWhen;
import org.rdlinux.ezmybatis.core.sqlstruct.SqlStruct;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.Formula;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EntityTable;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;
import org.rdlinux.ezmybatis.utils.Assert;

public class Function
implements SqlStruct {
    private Table table;
    private String funName;
    private List<FunArg> funArgs;

    private Function() {
    }

    public static FunctionBuilder builder(Table table) {
        return new FunctionBuilder(table);
    }

    public Table getTable() {
        return this.table;
    }

    public String getFunName() {
        return this.funName;
    }

    public List<FunArg> getFunArgs() {
        return this.funArgs;
    }

    public static class FunctionBuilder {
        private Function function = new Function();

        private FunctionBuilder(Table table) {
            this.function.table = table;
            this.function.funArgs = new LinkedList();
        }

        public FunctionBuilder setFunName(String name) {
            Assert.notEmpty(name, "function name can not be null");
            this.function.funName = name;
            return this;
        }

        public FunctionBuilder addColumnArg(boolean sure, Table table, String column) {
            if (!sure) {
                return this;
            }
            Assert.notNull(table, "table can not be null");
            Assert.notEmpty(column, "column can not be null");
            FunArg arg = new FunArg().setArgType(ArgType.COLUMN).setTable(table).setArgValue(column);
            this.function.funArgs.add(arg);
            return this;
        }

        public FunctionBuilder addColumnArg(Table table, String column) {
            return this.addColumnArg(true, table, column);
        }

        public FunctionBuilder addColumnArg(String column) {
            return this.addColumnArg(this.function.table, column);
        }

        public FunctionBuilder addColumnArg(boolean sure, String column) {
            return this.addColumnArg(sure, this.function.table, column);
        }

        public FunctionBuilder addFieldArg(boolean sure, Table table, String field) {
            if (!sure) {
                return this;
            }
            Assert.notNull(table, "table can not be null");
            Assert.notEmpty(field, "field can not be null");
            if (!(table instanceof EntityTable)) {
                throw new IllegalArgumentException("Only EntityTable is supported");
            }
            FunArg arg = new FunArg().setArgType(ArgType.FILED).setTable(table).setArgValue(field);
            this.function.funArgs.add(arg);
            return this;
        }

        public FunctionBuilder addFieldArg(Table table, String field) {
            return this.addFieldArg(true, table, field);
        }

        public FunctionBuilder addFieldArg(String field) {
            return this.addFieldArg(this.function.table, field);
        }

        public FunctionBuilder addFieldArg(boolean sure, String field) {
            return this.addFieldArg(sure, this.function.table, field);
        }

        public FunctionBuilder addFunArg(boolean sure, Function function) {
            if (!sure) {
                return this;
            }
            Assert.notNull(function, "function can not be null");
            FunArg arg = new FunArg().setArgType(ArgType.FUNC).setArgValue(function);
            this.function.funArgs.add(arg);
            return this;
        }

        public FunctionBuilder addFunArg(Function function) {
            return this.addFunArg(true, function);
        }

        public FunctionBuilder addFormulaArg(boolean sure, Formula formula) {
            if (!sure) {
                return this;
            }
            Assert.notNull(formula, "formula can not be null");
            FunArg arg = new FunArg().setArgType(ArgType.FORMULA).setArgValue(formula);
            this.function.funArgs.add(arg);
            return this;
        }

        public FunctionBuilder addFormulaArg(Formula formula) {
            return this.addFormulaArg(true, formula);
        }

        public FunctionBuilder addValueArg(boolean sure, Object argValue) {
            if (!sure) {
                return this;
            }
            FunArg arg = new FunArg().setArgType(ArgType.VALUE).setArgValue(argValue);
            this.function.funArgs.add(arg);
            return this;
        }

        public FunctionBuilder addValueArg(Object argValue) {
            return this.addValueArg(true, argValue);
        }

        public FunctionBuilder addKeywordsArg(boolean sure, String keywords) {
            if (!sure) {
                return this;
            }
            FunArg arg = new FunArg().setArgType(ArgType.KEYWORDS).setArgValue(keywords);
            this.function.funArgs.add(arg);
            return this;
        }

        public FunctionBuilder addKeywordsArg(String keywords) {
            return this.addKeywordsArg(true, keywords);
        }

        public FunctionBuilder addCaseWhenArg(boolean sure, CaseWhen caseWhen) {
            if (!sure) {
                return this;
            }
            FunArg arg = new FunArg().setArgType(ArgType.CASE_WHEN).setArgValue(caseWhen);
            this.function.funArgs.add(arg);
            return this;
        }

        public FunctionBuilder addCaseWhenArg(CaseWhen caseWhen) {
            return this.addCaseWhenArg(true, caseWhen);
        }

        public Function build() {
            return this.function;
        }
    }

    public static class FunArg {
        private Table table;
        private ArgType argType;
        private Object argValue;

        public Table getTable() {
            return this.table;
        }

        public ArgType getArgType() {
            return this.argType;
        }

        public Object getArgValue() {
            return this.argValue;
        }

        public FunArg setTable(Table table) {
            this.table = table;
            return this;
        }

        public FunArg setArgType(ArgType argType) {
            this.argType = argType;
            return this;
        }

        public FunArg setArgValue(Object argValue) {
            this.argValue = argValue;
            return this;
        }
    }
}

