/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.SqlStruct;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.utils.Assert;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;

public abstract class AbstractConverter<Obj extends SqlStruct>
implements Converter<Obj> {
    private Class<?> objClass = ReflectionUtils.getGenericSuperclass(this.getClass(), 0);

    @Override
    public StringBuilder buildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, Object struct, MybatisParamHolder mybatisParamHolder) {
        Assert.notNull((Object)type, "type can not be null");
        Assert.notNull(sqlBuilder, "sqlBuilder can not be null");
        Assert.notNull(configuration, "configuration can not be null");
        Assert.notNull(mybatisParamHolder, "mybatisParamHolder can not be null");
        if (struct == null) {
            return sqlBuilder;
        }
        if (!this.objClass.isAssignableFrom(struct.getClass())) {
            throw new IllegalArgumentException("Unsupported operation");
        }
        return this.doBuildSql(type, sqlBuilder, configuration, (SqlStruct)struct, mybatisParamHolder);
    }

    protected abstract StringBuilder doBuildSql(Converter.Type var1, StringBuilder var2, Configuration var3, Obj var4, MybatisParamHolder var5);
}

