/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import java.util.List;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.Where;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;

public class MySqlWhereConverter
extends AbstractConverter<Where>
implements Converter<Where> {
    private static volatile MySqlWhereConverter instance;

    protected MySqlWhereConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlWhereConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlWhereConverter> clazz = MySqlWhereConverter.class;
        synchronized (MySqlWhereConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlWhereConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected static StringBuilder conditionsToSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, MybatisParamHolder mybatisParamHolder, List<Condition> conditions) {
        boolean lastConditionEmpty = true;
        for (Condition condition : conditions) {
            Converter<?> converter = EzMybatisContent.getConverter(configuration, condition.getClass());
            String sqlPart = converter.buildSql(type, new StringBuilder(), configuration, condition, mybatisParamHolder).toString();
            boolean emptySql = sqlPart.trim().isEmpty();
            if (!lastConditionEmpty && !emptySql) {
                sqlBuilder.append(condition.getLogicalOperator().name()).append(" ");
            }
            if (!emptySql) {
                lastConditionEmpty = false;
                sqlBuilder.append(sqlPart);
                continue;
            }
            lastConditionEmpty = true;
        }
        return sqlBuilder;
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, Where where, MybatisParamHolder mybatisParamHolder) {
        if (type == Converter.Type.INSERT) {
            throw new UnsupportedOperationException("INSERT model unsupported");
        }
        if (where == null || where.getConditions() == null || where.getConditions().isEmpty()) {
            return sqlBuilder;
        }
        sqlBuilder.append(" WHERE ");
        return MySqlWhereConverter.conditionsToSql(type, sqlBuilder, configuration, mybatisParamHolder, where.getConditions());
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

