/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class ReflectionUtils {
    public static Class<?> getRealClassOfProxyClass(Class<?> objClass) {
        while (objClass.getSimpleName().contains("CGLIB$")) {
            objClass = objClass.getSuperclass();
        }
        return objClass;
    }

    public static List<Field> getAllFields(Class<?> objClass) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (objClass = ReflectionUtils.getRealClassOfProxyClass(objClass); objClass != Object.class; objClass = objClass.getSuperclass()) {
            fields.addAll(Arrays.asList(objClass.getDeclaredFields()));
        }
        return fields;
    }

    public static Class<?> getGenericSuperclass(Class<?> objClass, int order) {
        Type genType = objClass.getGenericSuperclass();
        while (!ParameterizedType.class.isAssignableFrom(genType.getClass())) {
            if (objClass == Object.class) {
                throw new IllegalArgumentException("Operation of this class is not supported");
            }
            objClass = objClass.getSuperclass();
            genType = objClass.getGenericSuperclass();
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        return (Class)params[order];
    }

    public static Class<?> getGenericSuperinterface(Class<?> objClass, int interfaceOrder, int paramOrder) {
        Type[] interfaces = objClass.getGenericInterfaces();
        Type[] actualTypeArguments = ((ParameterizedTypeImpl)interfaces[interfaceOrder]).getActualTypeArguments();
        return (Class)actualTypeArguments[paramOrder];
    }

    public static boolean isFinal(Field field) {
        return Modifier.isFinal(field.getModifiers());
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static <T> T getFieldValue(Object obj, Field field, boolean useGetter) {
        Object result;
        if (obj == null || field == null) {
            return null;
        }
        Class<?> objClass = ReflectionUtils.getRealClassOfProxyClass(obj.getClass());
        if (!useGetter) {
            field.setAccessible(true);
            try {
                result = field.get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Method getMethod = ReflectionUtils.getMethodOfFieldGet(objClass, field);
        getMethod.setAccessible(true);
        try {
            result = getMethod.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        return (T)result;
    }

    public static <T> T getFieldValue(Object obj, Field field) {
        return ReflectionUtils.getFieldValue(obj, field, false);
    }

    public static <T> T getFieldValue(Object obj, String fieldName, boolean useGetter) {
        if (obj == null || fieldName == null || fieldName.isEmpty()) {
            return null;
        }
        Field field = ReflectionUtils.getField(obj.getClass(), fieldName);
        if (field == null) {
            return null;
        }
        return ReflectionUtils.getFieldValue(obj, field, useGetter);
    }

    public static <T> T getFieldValue(Object obj, String fieldName) {
        return ReflectionUtils.getFieldValue(obj, fieldName, false);
    }

    public static Field getField(Class<?> objClass, String fieldName, Class<?> fieldType) {
        List<Field> fields = ReflectionUtils.getAllFields(objClass);
        for (Field field : fields) {
            if (!field.getName().equals(fieldName) || field.getType() != fieldType) continue;
            return field;
        }
        return null;
    }

    public static Field getField(Class<?> objClass, String fieldName) {
        List<Field> fields = ReflectionUtils.getAllFields(objClass);
        for (Field field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static Method getMethodOfFieldGet(Class<?> objClass, Field field) {
        Method methodOfGet;
        if (objClass == null || field == null) {
            return null;
        }
        objClass = ReflectionUtils.getRealClassOfProxyClass(objClass);
        String fieldName = field.getName();
        String prefix = "get";
        String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        if (Boolean.TYPE.isAssignableFrom(field.getType())) {
            if (fieldName.matches("^is[A-Z0-9_]+.*$")) {
                prefix = "";
                funSuffix = fieldName;
            } else {
                prefix = "is";
            }
        }
        try {
            methodOfGet = objClass.getMethod(prefix + funSuffix, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            if (objClass == Object.class) {
                throw new IllegalArgumentException(e);
            }
            return ReflectionUtils.getMethodOfFieldGet(objClass.getSuperclass(), field);
        }
        return methodOfGet;
    }

    public static Method getMethodOfFieldGet(Class<?> objClass, String fieldName) {
        if (objClass == null || fieldName == null || fieldName.isEmpty()) {
            return null;
        }
        Field field = ReflectionUtils.getField(objClass, fieldName);
        return ReflectionUtils.getMethodOfFieldGet(objClass, field);
    }

    public static void setFieldValue(Object obj, Field field, Object value, boolean useSetter) {
        if (obj == null || field == null) {
            return;
        }
        if (!useSetter) {
            field.setAccessible(true);
            try {
                field.set(obj, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Class<?> objClass = ReflectionUtils.getRealClassOfProxyClass(obj.getClass());
        Method methodOfSet = ReflectionUtils.getMethodOfFieldSet(objClass, field);
        methodOfSet.setAccessible(true);
        try {
            methodOfSet.invoke(obj, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        ReflectionUtils.setFieldValue(obj, field, value, false);
    }

    public static void setFieldValue(Object obj, String fieldName, Object value, boolean useSetter) {
        Field field;
        if (obj != null && fieldName != null && !fieldName.isEmpty() && (field = ReflectionUtils.getField(obj.getClass(), fieldName)) != null) {
            ReflectionUtils.setFieldValue(obj, field, value, useSetter);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        ReflectionUtils.setFieldValue(obj, fieldName, value, false);
    }

    public static Method getMethodOfFieldSet(Class<?> objClass, Field field) {
        Method methodOfSet;
        if (objClass == null || field == null) {
            return null;
        }
        objClass = ReflectionUtils.getRealClassOfProxyClass(objClass);
        String fieldName = field.getName();
        String funSuffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            methodOfSet = objClass.getMethod("set" + funSuffix, field.getType());
        }
        catch (NoSuchMethodException | SecurityException e) {
            if (objClass == Object.class) {
                throw new IllegalArgumentException(e);
            }
            return ReflectionUtils.getMethodOfFieldSet(objClass.getSuperclass(), field);
        }
        return methodOfSet;
    }

    public static Method getMethodOfFieldSet(Class<?> objClass, String fieldName) {
        if (objClass == null || fieldName == null || fieldName.isEmpty()) {
            return null;
        }
        Field field = ReflectionUtils.getField(objClass, fieldName);
        return ReflectionUtils.getMethodOfFieldSet(objClass, field);
    }

    public static Method getMethod(Class<?> objClass, String name, Class<?> ... parameterTypes) {
        try {
            Method method = objClass.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            if (objClass == Object.class) {
                throw new IllegalArgumentException(e);
            }
            return ReflectionUtils.getMethod(objClass.getSuperclass(), name, parameterTypes);
        }
    }

    public static <R> R invokeMethod(Object object, Method method, Object ... args) {
        method.setAccessible(true);
        try {
            return (R)method.invoke(object, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <R> R invokeMethod(Object object, String methodName, Class<?>[] argTypes, Object[] args) {
        Method method = ReflectionUtils.getMethod(object.getClass(), methodName, argTypes);
        return ReflectionUtils.invokeMethod(object, method, args);
    }
}

