/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.InterceptorChain;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.EzMybatisConfig;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzContentConfig;
import org.rdlinux.ezmybatis.core.EzMybatisInterceptorChain;
import org.rdlinux.ezmybatis.core.interceptor.EzMybatisExecutorInterceptor;
import org.rdlinux.ezmybatis.core.interceptor.EzMybatisResultSetHandlerInterceptor;
import org.rdlinux.ezmybatis.core.interceptor.EzMybatisUpdateInterceptor;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisDeleteListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisFieldSetListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisInsertListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisOnBuildSqlGetFieldListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisUpdateListener;
import org.rdlinux.ezmybatis.core.mapper.EzMapper;
import org.rdlinux.ezmybatis.core.sqlgenerate.DbKeywordQMFactory;
import org.rdlinux.ezmybatis.core.sqlstruct.EntityField;
import org.rdlinux.ezmybatis.core.sqlstruct.SqlStruct;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.DmConverterRegister;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.MySqlConverterRegister;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.OracleConverterRegister;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.PostgreSqlConverterRegister;
import org.rdlinux.ezmybatis.utils.Assert;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;

public class EzMybatisContent {
    private static final ConcurrentMap<Configuration, EzContentConfig> CFG_CONFIG_MAP = new ConcurrentHashMap<Configuration, EzContentConfig>();
    private static final Map<DbType, Map<Class<?>, Converter<?>>> CONVERT_MAP = new HashMap();
    private static final ThreadLocal<Deque<EntityField>> CURRENT_ACCESS_FIELD = new ThreadLocal();

    public static EntityField getCurrentAccessField() {
        Deque<EntityField> deque = CURRENT_ACCESS_FIELD.get();
        if (deque == null || deque.isEmpty()) {
            return null;
        }
        return CURRENT_ACCESS_FIELD.get().element();
    }

    public static void setCurrentAccessField(EntityField entityField) {
        Deque<EntityField> deque = CURRENT_ACCESS_FIELD.get();
        if (deque == null) {
            deque = new LinkedList<EntityField>();
            CURRENT_ACCESS_FIELD.set(deque);
        }
        deque.push(entityField);
    }

    public static void cleanCurrentAccessField() {
        Deque<EntityField> deque = CURRENT_ACCESS_FIELD.get();
        if (deque != null) {
            if (!deque.isEmpty()) {
                deque.poll();
            }
            if (deque.isEmpty()) {
                CURRENT_ACCESS_FIELD.remove();
            }
        }
    }

    public static synchronized <T extends SqlStruct> void addConverter(DbType dbType, Class<T> sqlStruct, Converter<T> converter) {
        CONVERT_MAP.putIfAbsent(dbType, new HashMap());
        CONVERT_MAP.get((Object)dbType).put(sqlStruct, converter);
    }

    public static <T extends SqlStruct> Converter<T> getConverter(DbType dbType, Class<T> sqlStruct) {
        Map<Class<?>, Converter<?>> convertMap = CONVERT_MAP.get((Object)dbType);
        if (convertMap == null) {
            throw new RuntimeException("cannot find the converter of " + dbType.name());
        }
        Converter<?> converter = convertMap.get(sqlStruct);
        if (converter == null) {
            throw new RuntimeException(String.format("%s cannot find the converter of %s", dbType.name(), sqlStruct.getSimpleName()));
        }
        return converter;
    }

    public static <T extends SqlStruct> Converter<T> getConverter(Configuration configuration, Class<T> sqlStruct) {
        DbType dbType = EzMybatisContent.getDbType(configuration);
        return EzMybatisContent.getConverter(dbType, sqlStruct);
    }

    public static void setDbType(Configuration configuration, DbType dbType) {
        Assert.notNull(configuration, "configuration can not be null");
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(configuration);
        Assert.notNull(configurationConfig, "please init");
        configurationConfig.setDbType(dbType);
        EzMybatisContent.initConverterRegister(dbType);
    }

    public static DbType getDbType(Configuration configuration) {
        Assert.notNull(configuration, "configuration can not be null");
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(configuration);
        Assert.notNull(configurationConfig, "please init");
        DbType dbType = configurationConfig.getDbType();
        if (dbType == null) {
            throw new RuntimeException("The database type is not recognized. Please configure it manually");
        }
        return dbType;
    }

    public static void init(EzMybatisConfig config) {
        EzContentConfig configurationConfig = new EzContentConfig();
        configurationConfig.setConfiguration(config.getConfiguration());
        configurationConfig.setDbKeywordQMFactory(new DbKeywordQMFactory(config));
        configurationConfig.setEzMybatisConfig(config);
        configurationConfig.setInsertListeners(new ArrayList<EzMybatisInsertListener>());
        configurationConfig.setUpdateListeners(new ArrayList<EzMybatisUpdateListener>());
        CFG_CONFIG_MAP.put(config.getConfiguration(), configurationConfig);
        EzMybatisContent.initMapper(config);
        EzMybatisContent.initInterceptor(config);
        EzMybatisContent.initDbType(config);
    }

    public static String getKeywordQM(Configuration configuration) {
        Assert.notNull(configuration, "configuration can not be null");
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(configuration);
        Assert.notNull(configurationConfig, "please init");
        return configurationConfig.getDbKeywordQMFactory().getKeywordQM();
    }

    public static List<EzMybatisInsertListener> getInsertListeners(Configuration configuration) {
        Assert.notNull(configuration, "configuration can not be null");
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(configuration);
        Assert.notNull(configurationConfig, "please init");
        return configurationConfig.getInsertListeners();
    }

    public static List<EzMybatisUpdateListener> getUpdateListeners(Configuration configuration) {
        Assert.notNull(configuration, "configuration can not be null");
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(configuration);
        Assert.notNull(configurationConfig, "please init");
        return configurationConfig.getUpdateListeners();
    }

    public static void addInsertListener(EzMybatisConfig config, EzMybatisInsertListener listener) {
        EzMybatisContent.checkInit(config);
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.getInsertListeners().add(listener);
        configurationConfig.getUpdateInterceptor().addInsertListener(listener);
    }

    public static void addUpdateListener(EzMybatisConfig config, EzMybatisUpdateListener listener) {
        EzMybatisContent.checkInit(config);
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.getUpdateListeners().add(listener);
        configurationConfig.getUpdateInterceptor().addUpdateListener(listener);
    }

    public static void addDeleteListener(EzMybatisConfig config, EzMybatisDeleteListener listener) {
        EzMybatisContent.checkInit(config);
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.getUpdateInterceptor().addDeleteListener(listener);
    }

    public static void addFieldSetListener(EzMybatisConfig config, EzMybatisFieldSetListener listener) {
        EzMybatisContent.checkInit(config);
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.addFieldSetListener(listener);
    }

    public static void addOnBuildSqlGetFieldListener(EzMybatisConfig config, EzMybatisOnBuildSqlGetFieldListener listener) {
        EzMybatisContent.checkInit(config);
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.addOnBuildSqlGetFieldListener(listener);
    }

    private static void checkInit(EzMybatisConfig config) {
        if (CFG_CONFIG_MAP.get(config.getConfiguration()) == null) {
            EzMybatisContent.init(config);
        }
    }

    private static void initMapper(EzMybatisConfig config) {
        config.getConfiguration().addMapper(EzMapper.class);
    }

    private static void initDbType(EzMybatisConfig config) {
        Configuration configuration = config.getConfiguration();
        Environment environment = configuration.getEnvironment();
        if (environment == null) {
            return;
        }
        DataSource dataSource = environment.getDataSource();
        if (dataSource == null) {
            return;
        }
        String driver = PooledDataSource.class.isAssignableFrom(dataSource.getClass()) ? ((PooledDataSource)dataSource).getDriver() : (dataSource.getClass().getName().contains("druid") ? (String)ReflectionUtils.getFieldValue((Object)dataSource, "driverClass") : (String)ReflectionUtils.getFieldValue((Object)dataSource, "driverClassName"));
        if (StringUtils.isBlank((CharSequence)driver)) {
            return;
        }
        DbType dbType = null;
        if (driver.contains("mysql")) {
            dbType = DbType.MYSQL;
        } else if (driver.contains("oracle")) {
            dbType = DbType.ORACLE;
        } else if (driver.toLowerCase().contains("dmdriver")) {
            dbType = DbType.DM;
        } else if (driver.toLowerCase().contains("postgresql")) {
            dbType = DbType.POSTGRE_SQL;
        }
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.setDbType(dbType);
        EzMybatisContent.initConverterRegister(dbType);
    }

    private static void initConverterRegister(DbType dbType) {
        if (dbType == null) {
            return;
        }
        if (dbType == DbType.MYSQL) {
            MySqlConverterRegister.register();
        } else if (dbType == DbType.ORACLE) {
            OracleConverterRegister.register();
        } else if (dbType == DbType.DM) {
            DmConverterRegister.register();
        } else if (dbType == DbType.POSTGRE_SQL) {
            PostgreSqlConverterRegister.register();
        }
    }

    private static void initInterceptor(EzMybatisConfig config) {
        Configuration configuration = config.getConfiguration();
        InterceptorChain interceptorChain = (InterceptorChain)ReflectionUtils.getFieldValue((Object)configuration, "interceptorChain");
        EzMybatisInterceptorChain ezMybatisInterceptorChain = new EzMybatisInterceptorChain(interceptorChain);
        ReflectionUtils.setFieldValue((Object)configuration, "interceptorChain", (Object)ezMybatisInterceptorChain);
        ezMybatisInterceptorChain.addEzInterceptor(new EzMybatisResultSetHandlerInterceptor());
        ezMybatisInterceptorChain.addEzInterceptor(new EzMybatisExecutorInterceptor());
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(config.getConfiguration());
        configurationConfig.setUpdateInterceptor(new EzMybatisUpdateInterceptor());
        ezMybatisInterceptorChain.addInterceptor(configurationConfig.getUpdateInterceptor());
    }

    public static EzContentConfig getContentConfig(Configuration configuration) {
        Assert.notNull(configuration, "configuration can not be null");
        EzContentConfig configurationConfig = (EzContentConfig)CFG_CONFIG_MAP.get(configuration);
        Assert.notNull(configurationConfig, "configurationConfig non-existent");
        return configurationConfig;
    }

    public static Object onFieldSet(Configuration configuration, Object obj, String field, Object value) {
        EzContentConfig contentConfig = EzMybatisContent.getContentConfig(configuration);
        List<EzMybatisFieldSetListener> listeners = contentConfig.getFieldSetListeners();
        if (listeners != null) {
            for (EzMybatisFieldSetListener listener : listeners) {
                value = listener.onSet(obj, field, value);
            }
        }
        return value;
    }

    public static Object onBuildSqlGetField(Configuration configuration, Class<?> ntType, Field field, Object value) {
        EzContentConfig contentConfig = EzMybatisContent.getContentConfig(configuration);
        List<EzMybatisOnBuildSqlGetFieldListener> listeners = contentConfig.getOnBuildSqlGetFieldListeners();
        if (listeners != null) {
            for (EzMybatisOnBuildSqlGetFieldListener listener : listeners) {
                value = listener.onGet(ntType, field, value);
            }
        }
        return value;
    }
}

