/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.classinfo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.core.classinfo.EzMybatisEntityInfoCache;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.utils.Assert;

public class DefaultEzMybatisEntityInfoCache
implements EzMybatisEntityInfoCache {
    protected static final ConcurrentMap<Configuration, ConcurrentMap<String, EntityClassInfo>> ENTITY_INFO_MAP = new ConcurrentHashMap<Configuration, ConcurrentMap<String, EntityClassInfo>>();
    private static final String CLASS_TAG = "target" + File.separator + "classes";
    private static final String CLASS_TEST_TAG = "target" + File.separator + "test-classes";
    private static final Log log = LogFactory.getLog(DefaultEzMybatisEntityInfoCache.class);

    public DefaultEzMybatisEntityInfoCache() {
        this.initClassFileChangeWatch();
    }

    private List<Path> findPath() {
        Path currentRunPath = Paths.get("", new String[0]).toAbsolutePath();
        Path parent = currentRunPath.getParent();
        File parentFile = new File(parent.toUri());
        File[] currentFiles = parentFile.listFiles((dir, name) -> !name.startsWith("."));
        File currentFile = new File(currentRunPath.toUri());
        File[] sonFiles = currentFile.listFiles((dir, name) -> !name.startsWith("."));
        LinkedList<File> listenFiles = new LinkedList<File>();
        if (currentFiles != null) {
            listenFiles.addAll(Arrays.asList(currentFiles));
        }
        if (sonFiles != null) {
            listenFiles.addAll(Arrays.asList(sonFiles));
        }
        LinkedList<Path> sonPaths = new LinkedList<Path>();
        for (File file : listenFiles) {
            if (!file.isDirectory()) continue;
            String absolutePath = file.getAbsolutePath();
            File sonFile = new File(absolutePath + File.separator + CLASS_TAG);
            if (sonFile.exists()) {
                sonPaths.add(Paths.get(absolutePath + File.separator + CLASS_TAG, new String[0]));
            }
            if (!(sonFile = new File(absolutePath + File.separator + CLASS_TEST_TAG)).exists()) continue;
            sonPaths.add(Paths.get(absolutePath + File.separator + CLASS_TEST_TAG, new String[0]));
        }
        return sonPaths;
    }

    protected void initClassFileChangeWatch() {
        List<Path> allPath;
        URL classLocation = DefaultEzMybatisEntityInfoCache.class.getResource("/");
        if (classLocation.toString().startsWith("jar:file:")) {
            if (log.isDebugEnabled()) {
                log.debug("Disable hot reloading of class information.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Enable hot reloading of class information.");
            log.debug("Hot reloading of class information is only supported for the built artifact directories in the project's \"target/classes\" and \"target/test-classes\".");
        }
        if ((allPath = this.findPath()).isEmpty()) {
            return;
        }
        Thread cleanThread = new Thread(() -> {
            try {
                final WatchService ws = FileSystems.getDefault().newWatchService();
                final WatchEvent.Kind[] kinds = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
                final HashMap keys = new HashMap(16);
                for (Path path : allPath) {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            keys.put(dir.register(ws, kinds), dir);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                while (true) {
                    Path path;
                    WatchKey watchKey = ws.take();
                    path = (Path)keys.get(watchKey);
                    String pathStr = path.toString();
                    List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
                    for (WatchEvent<?> event : watchEvents) {
                        if (!event.context().toString().endsWith(".class")) continue;
                        String flagStr = CLASS_TAG;
                        if (pathStr.contains(CLASS_TEST_TAG)) {
                            flagStr = CLASS_TEST_TAG;
                        }
                        String packageStr = pathStr.substring(pathStr.indexOf(flagStr) + flagStr.length() + 1).replace(File.separator, ".");
                        String className = event.context().toString().split("\\.")[0];
                        String key = packageStr + "." + className;
                        for (ConcurrentMap cache : ENTITY_INFO_MAP.values()) {
                            EntityClassInfo classInfo = (EntityClassInfo)cache.remove(key);
                            if (classInfo == null || !log.isDebugEnabled()) continue;
                            log.debug(String.format("Cleaning the class information of %s", key));
                        }
                    }
                    watchKey.reset();
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage());
                return;
            }
        });
        cleanThread.setDaemon(true);
        cleanThread.setName("ez-mybatis-entity-info-clean");
        cleanThread.start();
    }

    @Override
    public EntityClassInfo get(Configuration configuration, Class<?> ntClass) {
        Assert.notNull(configuration, "Configuration can not be null");
        Assert.notNull(ntClass, "NtClass can not be null");
        Map entityInfo = (Map)ENTITY_INFO_MAP.get(configuration);
        if (entityInfo == null) {
            return null;
        }
        return (EntityClassInfo)entityInfo.get(ntClass.getName());
    }

    @Override
    public void set(Configuration configuration, EntityClassInfo entityClassInfo) {
        Assert.notNull(configuration, "Configuration can not be null");
        Assert.notNull(entityClassInfo, "EntityClassInfo can not be null");
        ConcurrentHashMap<String, EntityClassInfo> entityInfo = (ConcurrentHashMap<String, EntityClassInfo>)ENTITY_INFO_MAP.get(configuration);
        if (entityInfo == null) {
            entityInfo = new ConcurrentHashMap<String, EntityClassInfo>();
            ENTITY_INFO_MAP.put(configuration, entityInfo);
        }
        entityInfo.put(entityClassInfo.getEntityClass().getName(), entityClassInfo);
    }
}

