/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.classinfo;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzContentConfig;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.classinfo.DefaultEzMybatisEntityInfoCache;
import org.rdlinux.ezmybatis.core.classinfo.EzMybatisEntityInfoCache;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.build.DmEntityInfoBuilder;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.build.EntityInfoBuilder;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.build.MySqlEntityInfoBuilder;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.build.OracleEntityInfoBuilder;
import org.rdlinux.ezmybatis.utils.Assert;

public class EzEntityClassInfoFactory {
    private static final Map<DbType, EntityInfoBuilder> ENTITY_INFO_BUILD_MAP = new ConcurrentHashMap<DbType, EntityInfoBuilder>();
    private static EzMybatisEntityInfoCache ENTITY_INFO_CACHE = new DefaultEzMybatisEntityInfoCache();

    private static EntityClassInfo buildInfo(Configuration configuration, Class<?> ntClass) {
        DbType dbType = EzMybatisContent.getDbType(configuration);
        EntityInfoBuilder infoBuild = ENTITY_INFO_BUILD_MAP.get((Object)dbType);
        EzContentConfig ezContentConfig = EzMybatisContent.getContentConfig(configuration);
        EntityClassInfo entityClassInfo = infoBuild.buildInfo(ezContentConfig, ntClass);
        ENTITY_INFO_CACHE.set(configuration, entityClassInfo);
        return entityClassInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityClassInfo forClass(Configuration configuration, Class<?> ntClass) {
        EntityClassInfo result = ENTITY_INFO_CACHE.get(configuration, ntClass);
        if (result == null) {
            Configuration configuration2 = configuration;
            synchronized (configuration2) {
                result = ENTITY_INFO_CACHE.get(configuration, ntClass);
                if (result == null) {
                    result = EzEntityClassInfoFactory.buildInfo(configuration, ntClass);
                }
            }
        }
        return result;
    }

    public static void setEntityInfoBuilder(EntityInfoBuilder entityInfoBuilder) {
        Assert.notNull(entityInfoBuilder, "The entity information builder cannot be empty.");
        Assert.notNull((Object)entityInfoBuilder.getSupportedDbType(), "The supported database type cannot be empty.");
        ENTITY_INFO_BUILD_MAP.put(entityInfoBuilder.getSupportedDbType(), entityInfoBuilder);
    }

    public static EntityInfoBuilder getEntityInfoBuild(Configuration configuration) {
        return ENTITY_INFO_BUILD_MAP.get((Object)EzMybatisContent.getDbType(configuration));
    }

    public static void setEntityInfoCache(EzMybatisEntityInfoCache entityInfoCache) {
        ENTITY_INFO_CACHE = entityInfoCache;
    }

    static {
        MySqlEntityInfoBuilder mySqlEntityInfoBuild = MySqlEntityInfoBuilder.getInstance();
        ENTITY_INFO_BUILD_MAP.put(mySqlEntityInfoBuild.getSupportedDbType(), mySqlEntityInfoBuild);
        OracleEntityInfoBuilder oracleEntityInfoBuild = OracleEntityInfoBuilder.getInstance();
        ENTITY_INFO_BUILD_MAP.put(oracleEntityInfoBuild.getSupportedDbType(), oracleEntityInfoBuild);
        DmEntityInfoBuilder dmEntityInfoBuild = DmEntityInfoBuilder.getInstance();
        ENTITY_INFO_BUILD_MAP.put(dmEntityInfoBuild.getSupportedDbType(), dmEntityInfoBuild);
        ENTITY_INFO_BUILD_MAP.put(DbType.POSTGRE_SQL, mySqlEntityInfoBuild);
    }
}

