/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.type.TypeHandler;
import org.rdlinux.ezmybatis.core.EzJdbcBatchSql;
import org.rdlinux.ezmybatis.core.EzJdbcSqlParam;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisUpdateListener;
import org.rdlinux.ezmybatis.core.sqlgenerate.SqlGenerateFactory;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;
import org.rdlinux.ezmybatis.utils.Assert;

public class JdbcUpdateDao {
    private static final Log log = LogFactory.getLog(JdbcUpdateDao.class);
    private SqlSession sqlSession;

    public JdbcUpdateDao(SqlSession sqlSession) {
        Assert.notNull(sqlSession, "sqlSession can not be null");
        this.sqlSession = sqlSession;
    }

    public int update(Object model) {
        return this.updateByTable(null, model);
    }

    public int updateByTable(Table table, Object model) {
        return this.doUpdate(table, Collections.singleton(model), false);
    }

    public int batchUpdate(Collection<?> models) {
        return this.doUpdate(null, models, false);
    }

    public int batchUpdateByTable(Table table, Collection<?> models) {
        return this.doUpdate(table, models, false);
    }

    public int replace(Object model) {
        return this.replaceByTable(null, model);
    }

    public int replaceByTable(Table table, Object model) {
        return this.doUpdate(table, Collections.singleton(model), true);
    }

    public int batchReplace(Collection<?> models) {
        return this.doUpdate(null, models, true);
    }

    public int batchReplaceByTable(Table table, Collection<?> models) {
        return this.doUpdate(table, models, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doUpdate(Table table, Collection<?> models, boolean isReplace) {
        Connection connection = this.sqlSession.getConnection();
        Configuration configuration = this.sqlSession.getConfiguration();
        List<EzMybatisUpdateListener> listeners = EzMybatisContent.getUpdateListeners(configuration);
        if (listeners != null) {
            for (EzMybatisUpdateListener listener : listeners) {
                if (isReplace) {
                    listener.onBatchReplace(models);
                    continue;
                }
                listener.onBatchUpdate(models);
            }
        }
        long start = System.currentTimeMillis();
        EzJdbcBatchSql jdbcBatchSql = SqlGenerateFactory.getSqlGenerate(EzMybatisContent.getDbType(configuration)).getJdbcBatchUpdateSql(configuration, table, models, isReplace);
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("SQL construction takes: " + (end - start) + "ms");
        }
        try (PreparedStatement statement = connection.prepareStatement(jdbcBatchSql.getSql());){
            int intRet;
            int[] intRets;
            start = System.currentTimeMillis();
            for (List<EzJdbcSqlParam> batchParam : jdbcBatchSql.getBatchParams()) {
                for (int i = 0; i < batchParam.size(); ++i) {
                    EzJdbcSqlParam param = batchParam.get(i);
                    TypeHandler typeHandler = param.getTypeHandler();
                    typeHandler.setParameter(statement, i + 1, param.getValue(), param.getJdbcType());
                }
                if (jdbcBatchSql.getBatchParams().size() <= 1) continue;
                statement.addBatch();
            }
            if (log.isDebugEnabled()) {
                end = System.currentTimeMillis();
                log.debug("SQL parameter setting takes: " + (end - start) + "ms");
            }
            start = System.currentTimeMillis();
            if (jdbcBatchSql.getBatchParams().size() == 1) {
                statement.execute();
                intRets = new int[]{1};
            } else {
                intRets = statement.executeBatch();
            }
            if (log.isDebugEnabled()) {
                end = System.currentTimeMillis();
                log.debug("SQL execution takes: " + (end - start) + "ms");
            }
            int ret = 0;
            int[] i = intRets;
            int n = i.length;
            for (int j = 0; j < n; ret += intRet, ++j) {
                intRet = i[j];
                if (intRet != -2) continue;
                ret = models.size();
                break;
            }
            if (log.isDebugEnabled()) {
                String msg = "==>  Preparing: " + jdbcBatchSql.getSql();
                msg = msg + "\n==> Parameters: *";
                msg = msg + "\n<==    Updates: " + ret;
                log.debug(msg);
            }
            int n2 = ret;
            return n2;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

