/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.mapper.provider;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.annotation.MethodName;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.EzQuery;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlgenerate.SqlGenerateFactory;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;

public class EzSelectProvider {
    public static final String SELECT_BY_ID_METHOD = "selectById";
    public static final String SELECT_BY_TABLE_AND_ID_METHOD = "selectByTableAndId";
    public static final String SELECT_BY_IDS_METHOD = "selectByIds";
    public static final String SELECT_BY_TABLE_AND_IDS_METHOD = "selectByTableAndIds";
    public static final String SELECT_BY_SQL_METHOD = "selectBySql";
    public static final String QUERY_METHOD = "query";
    public static final String QUERY_COUNT_METHOD = "queryCount";

    private static String handleInParam(String sql, Map<String, Object> sqlParam, MybatisParamHolder paramHolder) {
        Set<String> paramKeys = sqlParam.keySet();
        for (String paramKey : paramKeys) {
            Object value = sqlParam.get(paramKey);
            if (value == null || !(value instanceof Collection) && !value.getClass().isArray()) continue;
            Object[] valueArray = value instanceof Collection ? ((Collection)value).toArray() : (Object[])value;
            String regex = "(?i)\\b(IN)\\s*\\(*[#$]\\s*\\{\\s*" + paramKey + "\\s*}\\s*\\)*";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(sql);
            if (!matcher.find()) continue;
            StringBuilder subSql = new StringBuilder(" IN (");
            for (int i = 0; i < valueArray.length; ++i) {
                subSql.append(paramHolder.getMybatisParamName(valueArray[i]));
                if (i + 1 >= valueArray.length) continue;
                subSql.append(", ");
            }
            subSql.append(") ");
            sql = sql.replaceAll(regex, subSql.toString());
        }
        return sql;
    }

    @MethodName(value="selectById")
    public String selectById(Map<String, Object> param) {
        Configuration configuration = (Configuration)param.get("mp_configuration");
        MybatisParamHolder paramHolder = new MybatisParamHolder(configuration, param);
        Class ntClass = (Class)paramHolder.get("mp_ntClass");
        Object id = paramHolder.get("mp_id");
        return SqlGenerateFactory.getSqlGenerate(EzMybatisContent.getDbType(configuration)).getSelectByIdSql(configuration, paramHolder, null, ntClass, id);
    }

    @MethodName(value="selectByTableAndId")
    public String selectByTableAndId(Map<String, Object> param) {
        Configuration configuration = (Configuration)param.get("mp_configuration");
        MybatisParamHolder paramHolder = new MybatisParamHolder(configuration, param);
        Class ntClass = (Class)paramHolder.get("mp_ntClass");
        Table table = (Table)paramHolder.get("mp_table");
        Object id = paramHolder.get("mp_id");
        return SqlGenerateFactory.getSqlGenerate(EzMybatisContent.getDbType(configuration)).getSelectByIdSql(configuration, paramHolder, table, ntClass, id);
    }

    @MethodName(value="selectByIds")
    public String selectByIds(Map<String, Object> param) {
        Configuration configuration = (Configuration)param.get("mp_configuration");
        MybatisParamHolder paramHolder = new MybatisParamHolder(configuration, param);
        Class ntClass = (Class)paramHolder.get("mp_ntClass");
        Collection ids = (Collection)paramHolder.get("mp_ids");
        return SqlGenerateFactory.getSqlGenerate(EzMybatisContent.getDbType(configuration)).getSelectByIdsSql(configuration, paramHolder, null, ntClass, ids);
    }

    @MethodName(value="selectByTableAndIds")
    public String selectByTableAndIds(Map<String, Object> param) {
        Configuration configuration = (Configuration)param.get("mp_configuration");
        MybatisParamHolder paramHolder = new MybatisParamHolder(configuration, param);
        Class ntClass = (Class)paramHolder.get("mp_ntClass");
        Table table = (Table)paramHolder.get("mp_table");
        Collection ids = (Collection)paramHolder.get("mp_ids");
        return SqlGenerateFactory.getSqlGenerate(EzMybatisContent.getDbType(configuration)).getSelectByIdsSql(configuration, paramHolder, table, ntClass, ids);
    }

    @MethodName(value="selectBySql")
    public String selectBySql(Map<String, Object> param) {
        Configuration configuration = (Configuration)param.get("mp_configuration");
        MybatisParamHolder paramHolder = new MybatisParamHolder(configuration, param);
        String sql = (String)paramHolder.get("mp_sql");
        Map sqlParam = (Map)paramHolder.get("mp_sql_param");
        param.putAll(sqlParam);
        sql = EzSelectProvider.handleInParam(sql, sqlParam, paramHolder);
        return sql;
    }

    @MethodName(value="query")
    public String query(Map<String, Object> param) {
        Configuration configuration = (Configuration)param.get("mp_configuration");
        MybatisParamHolder paramHolder = new MybatisParamHolder(configuration, param);
        EzQuery query = (EzQuery)paramHolder.get("mp");
        return SqlGenerateFactory.getSqlGenerate(EzMybatisContent.getDbType(configuration)).getQuerySql(configuration, paramHolder, query);
    }

    @MethodName(value="queryCount")
    public String queryCount(Map<String, Object> param) {
        Configuration configuration = (Configuration)param.get("mp_configuration");
        MybatisParamHolder paramHolder = new MybatisParamHolder(configuration, param);
        EzQuery query = (EzQuery)paramHolder.get("mp");
        return SqlGenerateFactory.getSqlGenerate(EzMybatisContent.getDbType(configuration)).getQueryCountSql(configuration, paramHolder, query);
    }
}

