/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlgenerate;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.rdlinux.ezmybatis.core.EzJdbcBatchSql;
import org.rdlinux.ezmybatis.core.EzJdbcSqlParam;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.classinfo.EzEntityClassInfoFactory;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityFieldInfo;
import org.rdlinux.ezmybatis.core.sqlgenerate.AbstractInsertSqlGenerate;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlgenerate.UpdateSqlGenerate;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;
import org.rdlinux.ezmybatis.utils.Assert;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;
import org.rdlinux.ezmybatis.utils.TypeHandlerUtils;

public abstract class AbstractUpdateSqlGenerate
implements UpdateSqlGenerate {
    @Override
    public String getUpdateSql(Configuration configuration, MybatisParamHolder mybatisParamHolder, Table table, Object entity, boolean isReplace) {
        String tableName;
        Assert.notNull(entity, "entity can not be null");
        if (entity instanceof Collection) {
            throw new IllegalArgumentException("entity can not instanceof Collection");
        }
        String keywordQM = EzMybatisContent.getKeywordQM(configuration);
        EntityClassInfo entityClassInfo = EzEntityClassInfoFactory.forClass(configuration, entity.getClass());
        if (table != null) {
            Converter<?> converter = EzMybatisContent.getConverter(configuration, table.getClass());
            tableName = converter.buildSql(Converter.Type.UPDATE, new StringBuilder(), configuration, table, mybatisParamHolder).toString();
        } else {
            tableName = entityClassInfo.getTableNameWithSchema(keywordQM);
        }
        Map<String, EntityFieldInfo> columnMapFieldInfo = entityClassInfo.getColumnMapFieldInfo();
        EntityFieldInfo primaryKeyInfo = entityClassInfo.getPrimaryKeyInfo();
        String idColumn = primaryKeyInfo.getColumnName();
        Object idValue = ReflectionUtils.getFieldValue(entity, primaryKeyInfo.getField());
        StringBuilder sqlBuilder = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
        boolean invalidSql = true;
        for (String column : columnMapFieldInfo.keySet()) {
            EntityFieldInfo entityFieldInfo = columnMapFieldInfo.get(column);
            Method fieldGetMethod = entityFieldInfo.getFieldGetMethod();
            Object fieldValue = ReflectionUtils.invokeMethod(entity, fieldGetMethod, new Object[0]);
            if (!isReplace && fieldValue == null || column.equals(idColumn)) continue;
            sqlBuilder.append(keywordQM).append(column).append(keywordQM).append(" = ");
            sqlBuilder.append(mybatisParamHolder.getMybatisParamName(entity.getClass(), entityFieldInfo.getField(), fieldValue)).append(", ");
            invalidSql = false;
        }
        Assert.isTrue(!invalidSql, "cannot update empty entity");
        sqlBuilder.delete(sqlBuilder.length() - 2, sqlBuilder.length());
        sqlBuilder.append(" WHERE ").append(keywordQM).append(primaryKeyInfo.getColumnName()).append(keywordQM).append(" = ").append(mybatisParamHolder.getMybatisParamName(entity.getClass(), primaryKeyInfo.getField(), idValue));
        return sqlBuilder.toString();
    }

    @Override
    public String getBatchUpdateSql(Configuration configuration, MybatisParamHolder mybatisParamHolder, Table table, Collection<Object> entitys, boolean isReplace) {
        Assert.notEmpty(entitys, "entitys can not be empty");
        StringBuilder sqlBuilder = new StringBuilder();
        for (Object entity : entitys) {
            String sqlTmpl = this.getUpdateSql(configuration, mybatisParamHolder, table, entity, isReplace);
            sqlBuilder.append(sqlTmpl).append(";\n");
        }
        return sqlBuilder.toString();
    }

    @Override
    public EzJdbcBatchSql getJdbcBatchUpdateSql(Configuration configuration, Table table, Collection<?> models, boolean isReplace) {
        Assert.notNull(models, "models can not be null");
        Object firstEntity = models.iterator().next();
        MybatisParamHolder mybatisParamHolder = new MybatisParamHolder(configuration, new HashMap<String, Object>());
        String tableName = AbstractInsertSqlGenerate.getTableName(configuration, mybatisParamHolder, table, firstEntity);
        StringBuilder sqlBuilder = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
        String keywordQM = EzMybatisContent.getKeywordQM(configuration);
        EntityClassInfo entityClassInfo = EzEntityClassInfoFactory.forClass(configuration, firstEntity.getClass());
        EntityFieldInfo primaryKeyInfo = entityClassInfo.getPrimaryKeyInfo();
        List<Object> updateFieldInfo = new ArrayList<EntityFieldInfo>();
        Map<String, EntityFieldInfo> allColumnMapFieldInfo = entityClassInfo.getColumnMapFieldInfo();
        HashSet<String> existsUpdateFieldInfos = new HashSet<String>();
        if (isReplace) {
            updateFieldInfo = allColumnMapFieldInfo.values().stream().filter(e -> !e.isPrimaryKey()).collect(Collectors.toList());
        } else {
            for (EntityFieldInfo fieldInfo : allColumnMapFieldInfo.values()) {
                Method fieldGetMethod = fieldInfo.getFieldGetMethod();
                for (Object obj : models) {
                    if (!firstEntity.getClass().getName().equals(obj.getClass().getName())) {
                        throw new IllegalArgumentException("Inconsistent object types within the container");
                    }
                    Object fieldValue = ReflectionUtils.invokeMethod(obj, fieldGetMethod, new Object[0]);
                    if (fieldValue == null || fieldInfo.isPrimaryKey() || existsUpdateFieldInfos.contains(fieldInfo.getFieldName())) continue;
                    updateFieldInfo.add(fieldInfo);
                    existsUpdateFieldInfos.add(fieldInfo.getFieldName());
                }
            }
        }
        updateFieldInfo.add(primaryKeyInfo);
        Assert.isTrue(!updateFieldInfo.isEmpty(), "cannot update empty entity");
        EzJdbcBatchSql ret = new EzJdbcBatchSql();
        ArrayList<List<EzJdbcSqlParam>> params = new ArrayList<List<EzJdbcSqlParam>>(models.size());
        for (Object ignored : models) {
            params.add(new ArrayList(updateFieldInfo.size()));
        }
        int i = 1;
        for (EntityFieldInfo entityFieldInfo : updateFieldInfo) {
            if (!entityFieldInfo.isPrimaryKey()) {
                sqlBuilder.append(keywordQM).append(entityFieldInfo.getColumnName()).append(keywordQM).append(" = ?");
            }
            if (i < updateFieldInfo.size() - 1) {
                sqlBuilder.append(", ");
            }
            TypeHandler<?> typeHandler = TypeHandlerUtils.getTypeHandle(configuration, entityFieldInfo.getField());
            Method fieldGetMethod = entityFieldInfo.getFieldGetMethod();
            int eti = 0;
            for (Object model : models) {
                Object fieldValue = ReflectionUtils.invokeMethod(model, fieldGetMethod, new Object[0]);
                fieldValue = EzMybatisContent.onBuildSqlGetField(configuration, model.getClass(), entityFieldInfo.getField(), fieldValue);
                JdbcType jdbcType = TypeHandlerUtils.getJdbcType(fieldValue);
                EzJdbcSqlParam param = new EzJdbcSqlParam(fieldValue, typeHandler, jdbcType);
                ((List)params.get(eti)).add(param);
                ++eti;
            }
            ++i;
        }
        sqlBuilder.append(" WHERE ").append(keywordQM).append(primaryKeyInfo.getColumnName()).append(keywordQM).append(" = ?");
        ret.setSql(sqlBuilder.toString());
        ret.setBatchParams(params);
        return ret;
    }
}

