/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.rdlinux.ezmybatis.core.EzQuery;
import org.rdlinux.ezmybatis.core.sqlstruct.EntityField;
import org.rdlinux.ezmybatis.core.sqlstruct.Operand;
import org.rdlinux.ezmybatis.core.sqlstruct.TableColumn;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.ArgCompareArgCondition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.ExistsCondition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.SqlCondition;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EntityTable;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;
import org.rdlinux.ezmybatis.enumeration.AndOr;
import org.rdlinux.ezmybatis.enumeration.Operator;

public abstract class ConditionBuilder<ParentBuilder, SonBuilder> {
    protected ParentBuilder parentBuilder;
    protected SonBuilder sonBuilder = null;
    protected List<Condition> conditions;
    protected Table table;
    protected Table otherTable;

    public ConditionBuilder(ParentBuilder parentBuilder, List<Condition> conditions, Table table, Table otherTable) {
        this.parentBuilder = parentBuilder;
        this.conditions = conditions;
        this.table = table;
        this.otherTable = otherTable;
    }

    protected static List<?> valueToCollection(Object obj) {
        if (obj instanceof Collection) {
            return new ArrayList((Collection)obj);
        }
        if (obj.getClass().isArray()) {
            return Arrays.asList((Object[])obj);
        }
        return Collections.singletonList(obj);
    }

    protected static Operand valueToArg(Object value) {
        return Operand.objToOperand(value);
    }

    protected static List<Operand> valueToArgList(Object value) {
        List<?> objects = ConditionBuilder.valueToCollection(value);
        ArrayList<Operand> args = new ArrayList<Operand>(objects.size());
        for (Object datum : objects) {
            args.add(ConditionBuilder.valueToArg(datum));
        }
        return args;
    }

    public ParentBuilder done() {
        return this.parentBuilder;
    }

    protected void checkEntityTable() {
        if (!(this.table instanceof EntityTable)) {
            throw new IllegalArgumentException("Only EntityTable is supported");
        }
    }

    private void checkOtherEntityTable() {
        if (!(this.otherTable instanceof EntityTable)) {
            throw new IllegalArgumentException("Only EntityTable is supported");
        }
    }

    private void checkAllEntityTable() {
        this.checkEntityTable();
        this.checkOtherEntityTable();
    }

    public SonBuilder addCondition(boolean sure, AndOr andOr, Operand arg, Operator operator, Object value) {
        if (sure) {
            if (value == null) {
                this.conditions.add(new ArgCompareArgCondition(andOr, arg, Operator.isNull));
            } else if (operator == Operator.in || operator == Operator.notIn) {
                List<Operand> args = ConditionBuilder.valueToArgList(value);
                this.conditions.add(new ArgCompareArgCondition(andOr, arg, operator, args));
            } else {
                this.conditions.add(new ArgCompareArgCondition(andOr, arg, operator, ConditionBuilder.valueToArg(value)));
            }
        }
        return this.sonBuilder;
    }

    public SonBuilder addCondition(AndOr andOr, Operand arg, Operator operator, Object value) {
        return this.addCondition(true, andOr, arg, operator, value);
    }

    public SonBuilder addCondition(boolean sure, AndOr andOr, Operand arg, Object value) {
        return this.addCondition(sure, andOr, arg, Operator.eq, value);
    }

    public SonBuilder addCondition(AndOr andOr, Operand arg, Object value) {
        return this.addCondition(true, andOr, arg, Operator.eq, value);
    }

    public SonBuilder addCondition(boolean sure, Operand arg, Operator operator, Object value) {
        return this.addCondition(sure, AndOr.AND, arg, operator, value);
    }

    public SonBuilder addCondition(Operand arg, Operator operator, Object value) {
        return this.addCondition(true, arg, operator, value);
    }

    public SonBuilder addCondition(Operand arg, Object value) {
        return this.addCondition(arg, Operator.eq, value);
    }

    public SonBuilder addIsNullCondition(boolean sure, AndOr andOr, Operand arg) {
        if (sure) {
            this.conditions.add(new ArgCompareArgCondition(andOr, arg, Operator.isNull));
        }
        return this.sonBuilder;
    }

    public SonBuilder addIsNullCondition(boolean sure, Operand arg) {
        return this.addIsNullCondition(sure, AndOr.AND, arg);
    }

    public SonBuilder addIsNullCondition(AndOr andOr, Operand arg) {
        return this.addIsNullCondition(true, andOr, arg);
    }

    public SonBuilder addIsNullCondition(Operand arg) {
        return this.addIsNullCondition(true, AndOr.AND, arg);
    }

    public SonBuilder addIsNotNullCondition(boolean sure, AndOr andOr, Operand arg) {
        if (sure) {
            this.conditions.add(new ArgCompareArgCondition(andOr, arg, Operator.isNotNull));
        }
        return this.sonBuilder;
    }

    public SonBuilder addIsNotNullCondition(boolean sure, Operand arg) {
        return this.addIsNotNullCondition(sure, AndOr.AND, arg);
    }

    public SonBuilder addIsNotNullCondition(AndOr andOr, Operand arg) {
        return this.addIsNotNullCondition(true, andOr, arg);
    }

    public SonBuilder addIsNotNullCondition(Operand arg) {
        return this.addIsNotNullCondition(true, AndOr.AND, arg);
    }

    public SonBuilder addBtCondition(boolean sure, AndOr andOr, Operand arg, Operand minValue, Operand maxValue) {
        if (sure) {
            this.conditions.add(new ArgCompareArgCondition(andOr, arg, Operator.between, minValue, maxValue));
        }
        return this.sonBuilder;
    }

    public SonBuilder addBtCondition(boolean sure, Operand arg, Operand minValue, Operand maxValue) {
        return this.addBtCondition(sure, AndOr.AND, arg, minValue, maxValue);
    }

    public SonBuilder addBtCondition(AndOr andOr, Operand arg, Operand minValue, Operand maxValue) {
        return this.addBtCondition(true, andOr, arg, minValue, maxValue);
    }

    public SonBuilder addBtCondition(Operand arg, Operand minValue, Operand maxValue) {
        return this.addBtCondition(true, AndOr.AND, arg, minValue, maxValue);
    }

    public SonBuilder addNotBtCondition(boolean sure, AndOr andOr, Operand arg, Operand minValue, Operand maxValue) {
        if (sure) {
            this.conditions.add(new ArgCompareArgCondition(andOr, arg, Operator.notBetween, minValue, maxValue));
        }
        return this.sonBuilder;
    }

    public SonBuilder addNotBtCondition(boolean sure, Operand arg, Operand minValue, Operand maxValue) {
        return this.addNotBtCondition(sure, AndOr.AND, arg, minValue, maxValue);
    }

    public SonBuilder addNotBtCondition(AndOr andOr, Operand arg, Operand minValue, Operand maxValue) {
        return this.addNotBtCondition(true, andOr, arg, minValue, maxValue);
    }

    public SonBuilder addNotBtCondition(Operand arg, Operand minValue, Operand maxValue) {
        return this.addNotBtCondition(true, AndOr.AND, arg, minValue, maxValue);
    }

    public SonBuilder addFieldIsNullCondition(boolean sure, AndOr andOr, EntityTable table, String field) {
        return this.addIsNullCondition(sure, andOr, EntityField.of(table, field));
    }

    public SonBuilder addFieldIsNullCondition(String field) {
        this.checkEntityTable();
        return this.addFieldIsNullCondition(true, AndOr.AND, (EntityTable)this.table, field);
    }

    public SonBuilder addFieldIsNullCondition(EntityTable table, String field) {
        return this.addFieldIsNullCondition(true, AndOr.AND, table, field);
    }

    public SonBuilder addFieldIsNullCondition(boolean sure, String field) {
        this.checkEntityTable();
        return this.addFieldIsNullCondition(sure, AndOr.AND, (EntityTable)this.table, field);
    }

    public SonBuilder addFieldIsNullCondition(boolean sure, EntityTable table, String field) {
        return this.addFieldIsNullCondition(sure, AndOr.AND, table, field);
    }

    public SonBuilder addFieldIsNullCondition(AndOr andOr, EntityTable table, String field) {
        return this.addFieldIsNullCondition(true, andOr, table, field);
    }

    public SonBuilder addFieldIsNullCondition(AndOr andOr, String field) {
        this.checkEntityTable();
        return this.addFieldIsNullCondition(true, andOr, (EntityTable)this.table, field);
    }

    public SonBuilder addFieldIsNullCondition(boolean sure, AndOr andOr, String field) {
        this.checkEntityTable();
        return this.addFieldIsNullCondition(sure, andOr, (EntityTable)this.table, field);
    }

    public SonBuilder addColumnIsNullCondition(boolean sure, AndOr andOr, Table table, String column) {
        return this.addIsNullCondition(sure, andOr, TableColumn.of(table, column));
    }

    public SonBuilder addColumnIsNullCondition(String column) {
        return this.addColumnIsNullCondition(true, AndOr.AND, this.table, column);
    }

    public SonBuilder addColumnIsNullCondition(Table table, String column) {
        return this.addColumnIsNullCondition(true, AndOr.AND, table, column);
    }

    public SonBuilder addColumnIsNullCondition(boolean sure, String column) {
        return this.addColumnIsNullCondition(sure, AndOr.AND, this.table, column);
    }

    public SonBuilder addColumnIsNullCondition(boolean sure, Table table, String column) {
        return this.addColumnIsNullCondition(sure, AndOr.AND, table, column);
    }

    public SonBuilder addColumnIsNullCondition(AndOr andOr, Table table, String column) {
        return this.addColumnIsNullCondition(true, andOr, table, column);
    }

    public SonBuilder addColumnIsNullCondition(AndOr andOr, String column) {
        return this.addColumnIsNullCondition(true, andOr, this.table, column);
    }

    public SonBuilder addColumnIsNullCondition(boolean sure, AndOr andOr, String column) {
        return this.addColumnIsNullCondition(sure, andOr, this.table, column);
    }

    public SonBuilder addColumnIsNotNullCondition(boolean sure, AndOr andOr, Table table, String column) {
        return this.addIsNotNullCondition(sure, andOr, TableColumn.of(table, column));
    }

    public SonBuilder addColumnIsNotNullCondition(String column) {
        return this.addColumnIsNotNullCondition(true, AndOr.AND, this.table, column);
    }

    public SonBuilder addColumnIsNotNullCondition(Table table, String column) {
        return this.addColumnIsNotNullCondition(true, AndOr.AND, table, column);
    }

    public SonBuilder addColumnIsNotNullCondition(boolean sure, String column) {
        return this.addColumnIsNotNullCondition(sure, AndOr.AND, this.table, column);
    }

    public SonBuilder addColumnIsNotNullCondition(boolean sure, Table table, String column) {
        return this.addColumnIsNotNullCondition(sure, AndOr.AND, table, column);
    }

    public SonBuilder addColumnIsNotNullCondition(AndOr andOr, Table table, String column) {
        return this.addColumnIsNotNullCondition(true, andOr, table, column);
    }

    public SonBuilder addColumnIsNotNullCondition(AndOr andOr, String column) {
        return this.addColumnIsNotNullCondition(true, andOr, this.table, column);
    }

    public SonBuilder addColumnIsNotNullCondition(boolean sure, AndOr andOr, String column) {
        return this.addColumnIsNotNullCondition(sure, andOr, this.table, column);
    }

    public SonBuilder addFieldCondition(boolean sure, AndOr andOr, EntityTable table, String field, Operator operator, Object value) {
        return this.addCondition(sure, andOr, EntityField.of(table, field), operator, value);
    }

    public SonBuilder addFieldCondition(AndOr andOr, EntityTable table, String field, Operator operator, Object value) {
        return this.addFieldCondition(true, andOr, table, field, operator, value);
    }

    public SonBuilder addFieldCondition(AndOr andOr, String field, Operator operator, Object value) {
        this.checkEntityTable();
        return this.addFieldCondition(true, andOr, (EntityTable)this.table, field, operator, value);
    }

    public SonBuilder addFieldCondition(boolean sure, AndOr andOr, String field, Operator operator, Object value) {
        this.checkEntityTable();
        return this.addFieldCondition(sure, andOr, (EntityTable)this.table, field, operator, value);
    }

    public SonBuilder addFieldCondition(AndOr andOr, String field, Object value) {
        this.checkEntityTable();
        return this.addFieldCondition(true, andOr, (EntityTable)this.table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(AndOr andOr, EntityTable table, String field, Object value) {
        return this.addFieldCondition(true, andOr, table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(boolean sure, AndOr andOr, String field, Object value) {
        this.checkEntityTable();
        return this.addFieldCondition(sure, andOr, (EntityTable)this.table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(boolean sure, AndOr andOr, EntityTable table, String field, Object value) {
        return this.addFieldCondition(sure, andOr, table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(String field, Object value) {
        this.checkEntityTable();
        return this.addFieldCondition(true, AndOr.AND, (EntityTable)this.table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(EntityTable table, String field, Object value) {
        return this.addFieldCondition(true, AndOr.AND, table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(boolean sure, String field, Object value) {
        this.checkEntityTable();
        return this.addFieldCondition(sure, AndOr.AND, (EntityTable)this.table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(boolean sure, EntityTable table, String field, Object value) {
        return this.addFieldCondition(sure, AndOr.AND, table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(String field, Operator operator, Object value) {
        this.checkEntityTable();
        return this.addFieldCondition(true, AndOr.AND, (EntityTable)this.table, field, operator, value);
    }

    public SonBuilder addFieldCondition(EntityTable table, String field, Operator operator, Object value) {
        return this.addFieldCondition(true, AndOr.AND, table, field, operator, value);
    }

    public SonBuilder addFieldCondition(boolean sure, String field, Operator operator, Object value) {
        this.checkEntityTable();
        return this.addFieldCondition(sure, AndOr.AND, (EntityTable)this.table, field, operator, value);
    }

    public SonBuilder addFieldCondition(boolean sure, EntityTable table, String field, Operator operator, Object value) {
        return this.addFieldCondition(sure, AndOr.AND, table, field, operator, value);
    }

    public SonBuilder addFieldCondition(boolean sure, AndOr andOr, EntityTable table, String field, Operator operator, Operand value) {
        return this.addCondition(sure, andOr, EntityField.of(table, field), operator, value);
    }

    public SonBuilder addFieldCondition(AndOr andOr, EntityTable table, String field, Operator operator, Operand value) {
        return this.addFieldCondition(true, andOr, table, field, operator, value);
    }

    public SonBuilder addFieldCondition(AndOr andOr, String field, Operator operator, Operand value) {
        this.checkEntityTable();
        return this.addFieldCondition(true, andOr, (EntityTable)this.table, field, operator, value);
    }

    public SonBuilder addFieldCondition(boolean sure, AndOr andOr, String field, Operator operator, Operand value) {
        this.checkEntityTable();
        return this.addFieldCondition(sure, andOr, (EntityTable)this.table, field, operator, value);
    }

    public SonBuilder addFieldCondition(AndOr andOr, String field, Operand value) {
        this.checkEntityTable();
        return this.addFieldCondition(true, andOr, (EntityTable)this.table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(AndOr andOr, EntityTable table, String field, Operand value) {
        return this.addFieldCondition(true, andOr, table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(boolean sure, AndOr andOr, String field, Operand value) {
        this.checkEntityTable();
        return this.addFieldCondition(sure, andOr, (EntityTable)this.table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(boolean sure, AndOr andOr, EntityTable table, String field, Operand value) {
        return this.addFieldCondition(sure, andOr, table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(String field, Operand value) {
        this.checkEntityTable();
        return this.addFieldCondition(true, AndOr.AND, (EntityTable)this.table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(EntityTable table, String field, Operand value) {
        return this.addFieldCondition(true, AndOr.AND, table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(boolean sure, String field, Operand value) {
        this.checkEntityTable();
        return this.addFieldCondition(sure, AndOr.AND, (EntityTable)this.table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(boolean sure, EntityTable table, String field, Operand value) {
        return this.addFieldCondition(sure, AndOr.AND, table, field, Operator.eq, value);
    }

    public SonBuilder addFieldCondition(String field, Operator operator, Operand value) {
        this.checkEntityTable();
        return this.addFieldCondition(true, AndOr.AND, (EntityTable)this.table, field, operator, value);
    }

    public SonBuilder addFieldCondition(EntityTable table, String field, Operator operator, Operand value) {
        return this.addFieldCondition(true, AndOr.AND, table, field, operator, value);
    }

    public SonBuilder addFieldCondition(boolean sure, String field, Operator operator, Operand value) {
        this.checkEntityTable();
        return this.addFieldCondition(sure, AndOr.AND, (EntityTable)this.table, field, operator, value);
    }

    public SonBuilder addFieldCondition(boolean sure, EntityTable table, String field, Operator operator, Operand value) {
        return this.addFieldCondition(sure, AndOr.AND, table, field, operator, value);
    }

    public SonBuilder addColumnCondition(boolean sure, AndOr andOr, Table table, String column, Operator operator, Object value) {
        return this.addCondition(sure, andOr, TableColumn.of(table, column), operator, value);
    }

    public SonBuilder addColumnCondition(AndOr andOr, Table table, String column, Operator operator, Object value) {
        return this.addColumnCondition(true, andOr, table, column, operator, value);
    }

    public SonBuilder addColumnCondition(AndOr andOr, String column, Operator operator, Object value) {
        return this.addColumnCondition(true, andOr, this.table, column, operator, value);
    }

    public SonBuilder addColumnCondition(boolean sure, AndOr andOr, String column, Operator operator, Object value) {
        return this.addColumnCondition(sure, andOr, this.table, column, operator, value);
    }

    public SonBuilder addColumnCondition(AndOr andOr, String column, Object value) {
        return this.addColumnCondition(true, andOr, this.table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(AndOr andOr, Table table, String column, Object value) {
        return this.addColumnCondition(true, andOr, table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(boolean sure, AndOr andOr, String column, Object value) {
        return this.addColumnCondition(sure, andOr, this.table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(boolean sure, AndOr andOr, Table table, String column, Object value) {
        return this.addColumnCondition(sure, andOr, table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(String column, Object value) {
        return this.addColumnCondition(true, AndOr.AND, this.table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(Table table, String column, Object value) {
        return this.addColumnCondition(true, AndOr.AND, table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(boolean sure, String column, Object value) {
        return this.addColumnCondition(sure, AndOr.AND, this.table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(boolean sure, Table table, String column, Object value) {
        return this.addColumnCondition(sure, AndOr.AND, table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(String column, Operator operator, Object value) {
        return this.addColumnCondition(true, AndOr.AND, this.table, column, operator, value);
    }

    public SonBuilder addColumnCondition(Table table, String column, Operator operator, Object value) {
        return this.addColumnCondition(true, AndOr.AND, table, column, operator, value);
    }

    public SonBuilder addColumnCondition(boolean sure, String column, Operator operator, Object value) {
        return this.addColumnCondition(sure, AndOr.AND, this.table, column, operator, value);
    }

    public SonBuilder addColumnCondition(boolean sure, Table table, String column, Operator operator, Object value) {
        return this.addColumnCondition(sure, AndOr.AND, table, column, operator, value);
    }

    public SonBuilder addColumnCondition(boolean sure, AndOr andOr, Table table, String column, Operator operator, Operand value) {
        return this.addCondition(sure, andOr, TableColumn.of(table, column), operator, value);
    }

    public SonBuilder addColumnCondition(AndOr andOr, Table table, String column, Operator operator, Operand value) {
        return this.addColumnCondition(true, andOr, table, column, operator, value);
    }

    public SonBuilder addColumnCondition(AndOr andOr, String column, Operator operator, Operand value) {
        return this.addColumnCondition(true, andOr, this.table, column, operator, value);
    }

    public SonBuilder addColumnCondition(boolean sure, AndOr andOr, String column, Operator operator, Operand value) {
        return this.addColumnCondition(sure, andOr, this.table, column, operator, value);
    }

    public SonBuilder addColumnCondition(AndOr andOr, String column, Operand value) {
        return this.addColumnCondition(true, andOr, this.table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(AndOr andOr, Table table, String column, Operand value) {
        return this.addColumnCondition(true, andOr, table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(boolean sure, AndOr andOr, String column, Operand value) {
        return this.addColumnCondition(sure, andOr, this.table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(boolean sure, AndOr andOr, Table table, String column, Operand value) {
        return this.addColumnCondition(sure, andOr, table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(String column, Operand value) {
        return this.addColumnCondition(true, AndOr.AND, this.table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(Table table, String column, Operand value) {
        return this.addColumnCondition(true, AndOr.AND, table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(boolean sure, String column, Operand value) {
        return this.addColumnCondition(sure, AndOr.AND, this.table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(boolean sure, Table table, String column, Operand value) {
        return this.addColumnCondition(sure, AndOr.AND, table, column, Operator.eq, value);
    }

    public SonBuilder addColumnCondition(String column, Operator operator, Operand value) {
        return this.addColumnCondition(true, AndOr.AND, this.table, column, operator, value);
    }

    public SonBuilder addColumnCondition(Table table, String column, Operator operator, Operand value) {
        return this.addColumnCondition(true, AndOr.AND, table, column, operator, value);
    }

    public SonBuilder addColumnCondition(boolean sure, String column, Operator operator, Operand value) {
        return this.addColumnCondition(sure, AndOr.AND, this.table, column, operator, value);
    }

    public SonBuilder addColumnCondition(boolean sure, Table table, String column, Operator operator, Operand value) {
        return this.addColumnCondition(sure, AndOr.AND, table, column, operator, value);
    }

    public SonBuilder addFieldIsNotNullCondition(boolean sure, AndOr andOr, EntityTable table, String field) {
        return this.addIsNotNullCondition(sure, andOr, EntityField.of(table, field));
    }

    public SonBuilder addFieldIsNotNullCondition(String field) {
        this.checkEntityTable();
        return this.addFieldIsNotNullCondition(true, AndOr.AND, (EntityTable)this.table, field);
    }

    public SonBuilder addFieldIsNotNullCondition(EntityTable table, String field) {
        return this.addFieldIsNotNullCondition(true, AndOr.AND, table, field);
    }

    public SonBuilder addFieldIsNotNullCondition(boolean sure, String field) {
        this.checkEntityTable();
        return this.addFieldIsNotNullCondition(sure, AndOr.AND, (EntityTable)this.table, field);
    }

    public SonBuilder addFieldIsNotNullCondition(boolean sure, EntityTable table, String field) {
        return this.addFieldIsNotNullCondition(sure, AndOr.AND, table, field);
    }

    public SonBuilder addFieldIsNotNullCondition(AndOr andOr, EntityTable table, String field) {
        return this.addFieldIsNotNullCondition(true, andOr, table, field);
    }

    public SonBuilder addFieldIsNotNullCondition(AndOr andOr, String field) {
        this.checkEntityTable();
        return this.addFieldIsNotNullCondition(true, andOr, (EntityTable)this.table, field);
    }

    public SonBuilder addFieldIsNotNullCondition(boolean sure, AndOr andOr, String field) {
        this.checkEntityTable();
        return this.addFieldIsNotNullCondition(sure, andOr, (EntityTable)this.table, field);
    }

    public SonBuilder addFieldBtCondition(boolean sure, AndOr andOr, EntityTable table, String field, Object minValue, Object maxValue) {
        return this.addBtCondition(sure, andOr, EntityField.of(table, field), ConditionBuilder.valueToArg(minValue), ConditionBuilder.valueToArg(maxValue));
    }

    public SonBuilder addFieldBtCondition(AndOr andOr, String field, Object minValue, Object maxValue) {
        this.checkEntityTable();
        return this.addFieldBtCondition(true, andOr, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(AndOr andOr, EntityTable table, String field, Object minValue, Object maxValue) {
        return this.addFieldBtCondition(true, andOr, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(boolean sure, AndOr andOr, String field, Object minValue, Object maxValue) {
        this.checkEntityTable();
        return this.addFieldBtCondition(sure, andOr, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(String field, Object minValue, Object maxValue) {
        this.checkEntityTable();
        return this.addFieldBtCondition(true, AndOr.AND, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(EntityTable table, String field, Object minValue, Object maxValue) {
        return this.addFieldBtCondition(true, AndOr.AND, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(boolean sure, String field, Object minValue, Object maxValue) {
        this.checkEntityTable();
        return this.addFieldBtCondition(sure, AndOr.AND, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(boolean sure, EntityTable table, String field, Object minValue, Object maxValue) {
        return this.addFieldBtCondition(sure, AndOr.AND, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(boolean sure, AndOr andOr, EntityTable table, String field, Operand minValue, Operand maxValue) {
        return this.addBtCondition(sure, andOr, EntityField.of(table, field), ConditionBuilder.valueToArg(minValue), ConditionBuilder.valueToArg(maxValue));
    }

    public SonBuilder addFieldBtCondition(AndOr andOr, String field, Operand minValue, Operand maxValue) {
        this.checkEntityTable();
        return this.addFieldBtCondition(true, andOr, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(AndOr andOr, EntityTable table, String field, Operand minValue, Operand maxValue) {
        return this.addFieldBtCondition(true, andOr, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(boolean sure, AndOr andOr, String field, Operand minValue, Operand maxValue) {
        this.checkEntityTable();
        return this.addFieldBtCondition(sure, andOr, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(String field, Operand minValue, Operand maxValue) {
        this.checkEntityTable();
        return this.addFieldBtCondition(true, AndOr.AND, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(EntityTable table, String field, Operand minValue, Operand maxValue) {
        return this.addFieldBtCondition(true, AndOr.AND, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(boolean sure, String field, Operand minValue, Operand maxValue) {
        this.checkEntityTable();
        return this.addFieldBtCondition(sure, AndOr.AND, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldBtCondition(boolean sure, EntityTable table, String field, Operand minValue, Operand maxValue) {
        return this.addFieldBtCondition(sure, AndOr.AND, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(boolean sure, AndOr andOr, EntityTable table, String field, Object minValue, Object maxValue) {
        return this.addNotBtCondition(sure, andOr, EntityField.of(table, field), ConditionBuilder.valueToArg(minValue), ConditionBuilder.valueToArg(maxValue));
    }

    public SonBuilder addFieldNotBtCondition(AndOr andOr, String field, Object minValue, Object maxValue) {
        this.checkEntityTable();
        return this.addFieldNotBtCondition(true, andOr, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(AndOr andOr, EntityTable table, String field, Object minValue, Object maxValue) {
        return this.addFieldNotBtCondition(true, andOr, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(boolean sure, AndOr andOr, String field, Object minValue, Object maxValue) {
        this.checkEntityTable();
        return this.addFieldNotBtCondition(sure, andOr, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(String field, Object minValue, Object maxValue) {
        this.checkEntityTable();
        return this.addFieldNotBtCondition(true, AndOr.AND, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(EntityTable table, String field, Object minValue, Object maxValue) {
        return this.addFieldNotBtCondition(true, AndOr.AND, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(boolean sure, String field, Object minValue, Object maxValue) {
        this.checkEntityTable();
        return this.addFieldNotBtCondition(sure, AndOr.AND, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(boolean sure, EntityTable table, String field, Object minValue, Object maxValue) {
        return this.addFieldNotBtCondition(sure, AndOr.AND, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(boolean sure, AndOr andOr, EntityTable table, String field, Operand minValue, Operand maxValue) {
        return this.addNotBtCondition(sure, andOr, EntityField.of(table, field), ConditionBuilder.valueToArg(minValue), ConditionBuilder.valueToArg(maxValue));
    }

    public SonBuilder addFieldNotBtCondition(AndOr andOr, String field, Operand minValue, Operand maxValue) {
        this.checkEntityTable();
        return this.addFieldNotBtCondition(true, andOr, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(AndOr andOr, EntityTable table, String field, Operand minValue, Operand maxValue) {
        return this.addFieldNotBtCondition(true, andOr, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(boolean sure, AndOr andOr, String field, Operand minValue, Operand maxValue) {
        this.checkEntityTable();
        return this.addFieldNotBtCondition(sure, andOr, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(String field, Operand minValue, Operand maxValue) {
        this.checkEntityTable();
        return this.addFieldNotBtCondition(true, AndOr.AND, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(EntityTable table, String field, Operand minValue, Operand maxValue) {
        return this.addFieldNotBtCondition(true, AndOr.AND, table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(boolean sure, String field, Operand minValue, Operand maxValue) {
        this.checkEntityTable();
        return this.addFieldNotBtCondition(sure, AndOr.AND, (EntityTable)this.table, field, minValue, maxValue);
    }

    public SonBuilder addFieldNotBtCondition(boolean sure, EntityTable table, String field, Operand minValue, Operand maxValue) {
        return this.addFieldNotBtCondition(sure, AndOr.AND, table, field, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(boolean sure, AndOr andOr, Table table, String column, Object minValue, Object maxValue) {
        return this.addBtCondition(sure, andOr, TableColumn.of(table, column), ConditionBuilder.valueToArg(minValue), ConditionBuilder.valueToArg(maxValue));
    }

    public SonBuilder addColumnBtCondition(AndOr andOr, String column, Object minValue, Object maxValue) {
        return this.addColumnBtCondition(true, andOr, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(AndOr andOr, Table table, String column, Object minValue, Object maxValue) {
        return this.addColumnBtCondition(true, andOr, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(boolean sure, AndOr andOr, String column, Object minValue, Object maxValue) {
        return this.addColumnBtCondition(sure, andOr, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(String column, Object minValue, Object maxValue) {
        return this.addColumnBtCondition(true, AndOr.AND, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(Table table, String column, Object minValue, Object maxValue) {
        return this.addColumnBtCondition(true, AndOr.AND, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(boolean sure, String column, Object minValue, Object maxValue) {
        return this.addColumnBtCondition(sure, AndOr.AND, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(boolean sure, Table table, String column, Object minValue, Object maxValue) {
        return this.addColumnBtCondition(sure, AndOr.AND, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(boolean sure, AndOr andOr, Table table, String column, Operand minValue, Operand maxValue) {
        return this.addBtCondition(sure, andOr, TableColumn.of(table, column), ConditionBuilder.valueToArg(minValue), ConditionBuilder.valueToArg(maxValue));
    }

    public SonBuilder addColumnBtCondition(AndOr andOr, String column, Operand minValue, Operand maxValue) {
        return this.addColumnBtCondition(true, andOr, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(AndOr andOr, Table table, String column, Operand minValue, Operand maxValue) {
        return this.addColumnBtCondition(true, andOr, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(boolean sure, AndOr andOr, String column, Operand minValue, Operand maxValue) {
        return this.addColumnBtCondition(sure, andOr, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(String column, Operand minValue, Operand maxValue) {
        return this.addColumnBtCondition(true, AndOr.AND, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(Table table, String column, Operand minValue, Operand maxValue) {
        return this.addColumnBtCondition(true, AndOr.AND, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(boolean sure, String column, Operand minValue, Operand maxValue) {
        return this.addColumnBtCondition(sure, AndOr.AND, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnBtCondition(boolean sure, Table table, String column, Operand minValue, Operand maxValue) {
        return this.addColumnBtCondition(sure, AndOr.AND, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(boolean sure, AndOr andOr, Table table, String column, Object minValue, Object maxValue) {
        return this.addNotBtCondition(sure, andOr, TableColumn.of(table, column), ConditionBuilder.valueToArg(minValue), ConditionBuilder.valueToArg(maxValue));
    }

    public SonBuilder addColumnNotBtCondition(AndOr andOr, String column, Object minValue, Object maxValue) {
        return this.addColumnNotBtCondition(true, andOr, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(AndOr andOr, Table table, String column, Object minValue, Object maxValue) {
        return this.addColumnNotBtCondition(true, andOr, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(boolean sure, AndOr andOr, String column, Object minValue, Object maxValue) {
        return this.addColumnNotBtCondition(sure, andOr, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(String column, Object minValue, Object maxValue) {
        return this.addColumnNotBtCondition(true, AndOr.AND, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(Table table, String column, Object minValue, Object maxValue) {
        return this.addColumnNotBtCondition(true, AndOr.AND, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(boolean sure, String column, Object minValue, Object maxValue) {
        return this.addColumnNotBtCondition(sure, AndOr.AND, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(boolean sure, Table table, String column, Object minValue, Object maxValue) {
        return this.addColumnNotBtCondition(sure, AndOr.AND, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(AndOr andOr, String column, Operand minValue, Operand maxValue) {
        return this.addColumnNotBtCondition(true, andOr, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(AndOr andOr, Table table, String column, Operand minValue, Operand maxValue) {
        return this.addColumnNotBtCondition(true, andOr, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(boolean sure, AndOr andOr, String column, Operand minValue, Operand maxValue) {
        return this.addColumnNotBtCondition(sure, andOr, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(String column, Operand minValue, Operand maxValue) {
        return this.addColumnNotBtCondition(true, AndOr.AND, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(Table table, String column, Operand minValue, Operand maxValue) {
        return this.addColumnNotBtCondition(true, AndOr.AND, table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(boolean sure, String column, Operand minValue, Operand maxValue) {
        return this.addColumnNotBtCondition(sure, AndOr.AND, this.table, column, minValue, maxValue);
    }

    public SonBuilder addColumnNotBtCondition(boolean sure, Table table, String column, Operand minValue, Operand maxValue) {
        return this.addColumnNotBtCondition(sure, AndOr.AND, table, column, minValue, maxValue);
    }

    public SonBuilder addFieldCompareCondition(boolean sure, AndOr andOr, EntityTable leftTable, String leftField, Operator operator, EntityTable rightTable, String rightField) {
        return this.addCondition(sure, andOr, EntityField.of(leftTable, leftField), operator, EntityField.of(rightTable, rightField));
    }

    public SonBuilder addFieldCompareCondition(boolean sure, EntityTable leftTable, String leftField, Operator operator, EntityTable rightTable, String rightField) {
        return this.addFieldCompareCondition(sure, AndOr.AND, leftTable, leftField, operator, rightTable, rightField);
    }

    public SonBuilder addFieldCompareCondition(AndOr andOr, EntityTable leftTable, String leftField, Operator operator, EntityTable rightTable, String rightField) {
        return this.addFieldCompareCondition(true, andOr, leftTable, leftField, operator, rightTable, rightField);
    }

    public SonBuilder addFieldCompareCondition(EntityTable leftTable, String leftField, Operator operator, EntityTable rightTable, String rightField) {
        return this.addFieldCompareCondition(true, AndOr.AND, leftTable, leftField, operator, rightTable, rightField);
    }

    public SonBuilder addFieldCompareCondition(AndOr andOr, String leftField, Operator operator, String rightField) {
        this.checkAllEntityTable();
        return this.addFieldCompareCondition(true, andOr, (EntityTable)this.table, leftField, operator, (EntityTable)this.otherTable, rightField);
    }

    public SonBuilder addFieldCompareCondition(String leftField, Operator operator, String rightField) {
        this.checkAllEntityTable();
        return this.addFieldCompareCondition(true, AndOr.AND, (EntityTable)this.table, leftField, operator, (EntityTable)this.otherTable, rightField);
    }

    public SonBuilder addFieldCompareCondition(String leftField, String rightField) {
        this.checkAllEntityTable();
        return this.addFieldCompareCondition(true, AndOr.AND, (EntityTable)this.table, leftField, Operator.eq, (EntityTable)this.otherTable, rightField);
    }

    public SonBuilder addFieldCompareCondition(boolean sure, String leftField, String rightField) {
        this.checkAllEntityTable();
        return this.addFieldCompareCondition(sure, AndOr.AND, (EntityTable)this.table, leftField, Operator.eq, (EntityTable)this.otherTable, rightField);
    }

    public SonBuilder addFieldCompareCondition(AndOr andOr, String leftField, String rightField) {
        this.checkAllEntityTable();
        return this.addFieldCompareCondition(true, andOr, (EntityTable)this.table, leftField, Operator.eq, (EntityTable)this.otherTable, rightField);
    }

    public SonBuilder addFieldCompareCondition(boolean sure, AndOr andOr, String leftField, String rightField) {
        this.checkAllEntityTable();
        return this.addFieldCompareCondition(sure, andOr, (EntityTable)this.table, leftField, Operator.eq, (EntityTable)this.otherTable, rightField);
    }

    public SonBuilder addFieldCompareCondition(boolean sure, String leftField, Operator operator, String rightField) {
        this.checkAllEntityTable();
        return this.addFieldCompareCondition(sure, AndOr.AND, (EntityTable)this.table, leftField, operator, (EntityTable)this.otherTable, rightField);
    }

    public SonBuilder addFieldCompareCondition(boolean sure, AndOr andOr, String leftField, Operator operator, String rightField) {
        this.checkAllEntityTable();
        return this.addFieldCompareCondition(sure, andOr, (EntityTable)this.table, leftField, operator, (EntityTable)this.otherTable, rightField);
    }

    public SonBuilder addColumnCompareCondition(boolean sure, AndOr andOr, Table leftTable, String leftColumn, Operator operator, Table rightTable, String rightColumn) {
        return this.addCondition(sure, andOr, TableColumn.of(leftTable, leftColumn), operator, TableColumn.of(rightTable, rightColumn));
    }

    public SonBuilder addColumnCompareCondition(boolean sure, Table leftTable, String leftColumn, Operator operator, Table rightTable, String rightColumn) {
        return this.addColumnCompareCondition(sure, AndOr.AND, leftTable, leftColumn, operator, rightTable, rightColumn);
    }

    public SonBuilder addColumnCompareCondition(AndOr andOr, Table leftTable, String leftColumn, Operator operator, Table rightTable, String rightColumn) {
        return this.addColumnCompareCondition(true, andOr, leftTable, leftColumn, operator, rightTable, rightColumn);
    }

    public SonBuilder addColumnCompareCondition(Table leftTable, String leftColumn, Operator operator, Table rightTable, String rightColumn) {
        return this.addColumnCompareCondition(true, AndOr.AND, leftTable, leftColumn, operator, rightTable, rightColumn);
    }

    public SonBuilder addColumnCompareCondition(AndOr andOr, String leftColumn, Operator operator, String rightColumn) {
        return this.addColumnCompareCondition(true, andOr, this.table, leftColumn, operator, this.otherTable, rightColumn);
    }

    public SonBuilder addColumnCompareCondition(String leftColumn, Operator operator, String rightColumn) {
        return this.addColumnCompareCondition(true, AndOr.AND, this.table, leftColumn, operator, this.otherTable, rightColumn);
    }

    public SonBuilder addColumnCompareCondition(String leftColumn, String rightColumn) {
        return this.addColumnCompareCondition(true, AndOr.AND, this.table, leftColumn, Operator.eq, this.otherTable, rightColumn);
    }

    public SonBuilder addColumnCompareCondition(boolean sure, String leftColumn, String rightColumn) {
        return this.addColumnCompareCondition(sure, AndOr.AND, this.table, leftColumn, Operator.eq, this.otherTable, rightColumn);
    }

    public SonBuilder addColumnCompareCondition(AndOr andOr, String leftColumn, String rightColumn) {
        return this.addColumnCompareCondition(true, andOr, this.table, leftColumn, Operator.eq, this.otherTable, rightColumn);
    }

    public SonBuilder addColumnCompareCondition(boolean sure, AndOr andOr, String leftColumn, String rightColumn) {
        return this.addColumnCompareCondition(sure, andOr, this.table, leftColumn, Operator.eq, this.otherTable, rightColumn);
    }

    public SonBuilder addColumnCompareCondition(boolean sure, String leftColumn, Operator operator, String rightColumn) {
        return this.addColumnCompareCondition(sure, AndOr.AND, this.table, leftColumn, operator, this.otherTable, rightColumn);
    }

    public SonBuilder addColumnCompareCondition(boolean sure, AndOr andOr, String leftColumn, Operator operator, String rightColumn) {
        return this.addColumnCompareCondition(sure, andOr, this.table, leftColumn, operator, this.otherTable, rightColumn);
    }

    public SonBuilder addSqlCondition(boolean sure, AndOr andOr, String sql) {
        if (sure) {
            this.conditions.add(new SqlCondition(andOr, sql));
        }
        return this.sonBuilder;
    }

    public SonBuilder addSqlCondition(AndOr andOr, String sql) {
        return this.addSqlCondition(true, andOr, sql);
    }

    public SonBuilder addSqlCondition(boolean sure, String sql) {
        if (sure) {
            this.conditions.add(new SqlCondition(AndOr.AND, sql));
        }
        return this.sonBuilder;
    }

    public SonBuilder addSqlCondition(String sql) {
        return this.addSqlCondition(true, sql);
    }

    public SonBuilder exists(boolean sure, AndOr andOr, EzQuery<?> query) {
        if (sure) {
            this.conditions.add(new ExistsCondition(andOr, query, false));
        }
        return this.sonBuilder;
    }

    public SonBuilder exists(AndOr andOr, EzQuery<?> query) {
        return this.exists(true, andOr, query);
    }

    public SonBuilder exists(boolean sure, EzQuery<?> query) {
        return this.exists(sure, AndOr.AND, query);
    }

    public SonBuilder exists(EzQuery<?> query) {
        return this.exists(true, query);
    }

    public SonBuilder notExists(boolean sure, AndOr andOr, EzQuery<?> query) {
        if (sure) {
            this.conditions.add(new ExistsCondition(andOr, query, true));
        }
        return this.sonBuilder;
    }

    public SonBuilder notExists(AndOr andOr, EzQuery<?> query) {
        return this.notExists(true, andOr, query);
    }

    public SonBuilder notExists(boolean sure, EzQuery<?> query) {
        return this.notExists(sure, AndOr.AND, query);
    }

    public SonBuilder notExists(EzQuery<?> query) {
        return this.notExists(true, query);
    }
}

