/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.EntityField;
import org.rdlinux.ezmybatis.core.sqlstruct.MultipleRetOperand;
import org.rdlinux.ezmybatis.core.sqlstruct.Operand;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.ArgCompareArgCondition;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.enumeration.Operator;

public class MySqlArgCompareArgConditionConverter
extends AbstractConverter<ArgCompareArgCondition>
implements Converter<ArgCompareArgCondition> {
    private static volatile MySqlArgCompareArgConditionConverter instance;

    protected MySqlArgCompareArgConditionConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlArgCompareArgConditionConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlArgCompareArgConditionConverter> clazz = MySqlArgCompareArgConditionConverter.class;
        synchronized (MySqlArgCompareArgConditionConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlArgCompareArgConditionConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected String getOperatorStr(Operator operator) {
        return operator.getOperator();
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, ArgCompareArgCondition obj, MybatisParamHolder mybatisParamHolder) {
        Operand leftValue = obj.getLeftValue();
        if (leftValue instanceof EntityField) {
            EzMybatisContent.setCurrentAccessField((EntityField)leftValue);
        }
        Converter<?> leftConverter = EzMybatisContent.getConverter(configuration, leftValue.getClass());
        StringBuilder leftSql = new StringBuilder();
        leftSql.append(" ").append((CharSequence)leftConverter.buildSql(type, new StringBuilder(), configuration, leftValue, mybatisParamHolder)).append(" ");
        Operator operator = obj.getOperator();
        StringBuilder ret = operator == Operator.isNull || operator == Operator.isNotNull ? this.isNullBuild(leftSql, sqlBuilder, obj) : (operator == Operator.between || operator == Operator.notBetween ? this.isBetweenBuild(leftSql, type, sqlBuilder, configuration, obj, mybatisParamHolder) : (operator == Operator.in || operator == Operator.notIn ? this.inBuild(leftSql, type, sqlBuilder, configuration, obj, mybatisParamHolder) : this.normalBuild(leftSql, type, sqlBuilder, configuration, obj, mybatisParamHolder)));
        if (leftValue instanceof EntityField) {
            EzMybatisContent.cleanCurrentAccessField();
        }
        return ret;
    }

    private StringBuilder normalBuild(StringBuilder leftSql, Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, ArgCompareArgCondition obj, MybatisParamHolder mybatisParamHolder) {
        Operator operator = obj.getOperator();
        Operand value = obj.getRightValue();
        Converter<?> argConverter = EzMybatisContent.getConverter(configuration, value.getClass());
        return sqlBuilder.append(" ").append((CharSequence)leftSql).append(" ").append(this.getOperatorStr(operator)).append(" ").append((CharSequence)argConverter.buildSql(type, new StringBuilder(), configuration, value, mybatisParamHolder)).append(" ");
    }

    private StringBuilder inBuild(StringBuilder leftSql, Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, ArgCompareArgCondition obj, MybatisParamHolder mybatisParamHolder) {
        Operator operator = obj.getOperator();
        if (obj.getRightValues().size() == 1 && !(obj.getRightValues().get(0) instanceof MultipleRetOperand)) {
            operator = operator == Operator.in ? Operator.eq : Operator.ne;
        }
        sqlBuilder.append(" ").append((CharSequence)leftSql).append(" ").append(this.getOperatorStr(operator)).append(" ");
        if (operator == Operator.in || operator == Operator.notIn) {
            sqlBuilder.append("(");
        }
        for (int i = 0; i < obj.getRightValues().size(); ++i) {
            Operand arg = obj.getRightValues().get(i);
            Converter<?> argConverter = EzMybatisContent.getConverter(configuration, arg.getClass());
            sqlBuilder.append((CharSequence)argConverter.buildSql(type, new StringBuilder(), configuration, arg, mybatisParamHolder));
            if (i + 1 >= obj.getRightValues().size()) continue;
            sqlBuilder.append(", ");
        }
        if (operator == Operator.in || operator == Operator.notIn) {
            sqlBuilder.append(")");
        }
        sqlBuilder.append(" ");
        return sqlBuilder;
    }

    private StringBuilder isBetweenBuild(StringBuilder leftSql, Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, ArgCompareArgCondition obj, MybatisParamHolder mybatisParamHolder) {
        Operator operator = obj.getOperator();
        Converter<?> minArgConverter = EzMybatisContent.getConverter(configuration, obj.getMinValue().getClass());
        Converter<?> maxArgConverter = EzMybatisContent.getConverter(configuration, obj.getMaxValue().getClass());
        return sqlBuilder.append(" ").append((CharSequence)leftSql).append(" ").append(this.getOperatorStr(operator)).append(" ").append((CharSequence)minArgConverter.buildSql(type, new StringBuilder(), configuration, obj.getMinValue(), mybatisParamHolder)).append(" AND ").append((CharSequence)maxArgConverter.buildSql(type, new StringBuilder(), configuration, obj.getMaxValue(), mybatisParamHolder)).append(" ");
    }

    private StringBuilder isNullBuild(StringBuilder leftSql, StringBuilder sqlBuilder, ArgCompareArgCondition obj) {
        Operator operator = obj.getOperator();
        return sqlBuilder.append(" ").append((CharSequence)leftSql).append(" ").append(this.getOperatorStr(operator)).append(" ");
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

