/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.classinfo.EzEntityClassInfoFactory;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityFieldInfo;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.EntityField;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EntityTable;
import org.rdlinux.ezmybatis.core.sqlstruct.update.UpdateColumnItem;
import org.rdlinux.ezmybatis.utils.SqlEscaping;

public class MySqlUpdateColumnItemConverter
extends AbstractConverter<UpdateColumnItem>
implements Converter<UpdateColumnItem> {
    private static volatile MySqlUpdateColumnItemConverter instance;

    protected MySqlUpdateColumnItemConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlUpdateColumnItemConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlUpdateColumnItemConverter> clazz = MySqlUpdateColumnItemConverter.class;
        synchronized (MySqlUpdateColumnItemConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlUpdateColumnItemConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected boolean appendAlias() {
        return true;
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, UpdateColumnItem obj, MybatisParamHolder mybatisParamHolder) {
        EntityClassInfo entityClassInfo;
        String column = obj.getColumn();
        EntityFieldInfo entityFieldInfo = null;
        if (obj.getTable() instanceof EntityTable && (entityFieldInfo = (entityClassInfo = EzEntityClassInfoFactory.forClass(configuration, ((EntityTable)obj.getTable()).getEtType())).getColumnMapFieldInfo().get(column)) != null) {
            EzMybatisContent.setCurrentAccessField(EntityField.of((EntityTable)obj.getTable(), entityFieldInfo.getFieldName()));
        }
        Converter<?> argConverter = EzMybatisContent.getConverter(configuration, obj.getValue().getClass());
        StringBuilder valueSql = argConverter.buildSql(type, new StringBuilder(), configuration, obj.getValue(), mybatisParamHolder);
        String keywordQM = EzMybatisContent.getKeywordQM(configuration);
        if (this.appendAlias()) {
            sqlBuilder.append(obj.getTable().getAlias()).append(".");
        }
        sqlBuilder.append(keywordQM).append(SqlEscaping.nameEscaping(column)).append(keywordQM).append(" = ").append((CharSequence)valueSql);
        if (entityFieldInfo != null) {
            EzMybatisContent.cleanCurrentAccessField();
        }
        return sqlBuilder;
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

