/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.Where;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;

public class MySqlWhereConverter
extends AbstractConverter<Where>
implements Converter<Where> {
    private static volatile MySqlWhereConverter instance;

    protected MySqlWhereConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlWhereConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlWhereConverter> clazz = MySqlWhereConverter.class;
        synchronized (MySqlWhereConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlWhereConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected static StringBuilder conditionsToSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, MybatisParamHolder mybatisParamHolder, List<Condition> conditions) {
        boolean beforeHasCondition = false;
        for (Condition condition : conditions) {
            Converter<?> converter = EzMybatisContent.getConverter(configuration, condition.getClass());
            String sqlPart = converter.buildSql(type, new StringBuilder(), configuration, condition, mybatisParamHolder).toString();
            boolean emptySql = sqlPart.trim().isEmpty();
            if (emptySql) continue;
            if (beforeHasCondition) {
                sqlBuilder.append(condition.getAndOr().name()).append(" ");
            }
            sqlBuilder.append(sqlPart);
            beforeHasCondition = true;
        }
        return sqlBuilder;
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, Where where, MybatisParamHolder mybatisParamHolder) {
        if (type == Converter.Type.INSERT) {
            throw new UnsupportedOperationException("INSERT model unsupported");
        }
        if (where == null) {
            return sqlBuilder;
        }
        if (where.getConditions() == null || where.getConditions().isEmpty()) {
            return sqlBuilder.append(" WHERE 1 = 1 ");
        }
        String sonSql = MySqlWhereConverter.conditionsToSql(type, new StringBuilder(), configuration, mybatisParamHolder, where.getConditions()).toString();
        if (StringUtils.isBlank((CharSequence)sonSql)) {
            sonSql = " 1 = 1 ";
        }
        sqlBuilder.append(" WHERE ").append(sonSql);
        return sqlBuilder;
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

