/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.oracle;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.EntityField;
import org.rdlinux.ezmybatis.core.sqlstruct.Operand;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.ArgCompareArgCondition;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql.MySqlArgCompareArgConditionConverter;
import org.rdlinux.ezmybatis.enumeration.Operator;

public class OracleArgCompareArgConditionConverter
extends MySqlArgCompareArgConditionConverter
implements Converter<ArgCompareArgCondition> {
    private static volatile OracleArgCompareArgConditionConverter instance;

    protected OracleArgCompareArgConditionConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OracleArgCompareArgConditionConverter getInstance() {
        if (instance != null) return instance;
        Class<OracleArgCompareArgConditionConverter> clazz = OracleArgCompareArgConditionConverter.class;
        synchronized (OracleArgCompareArgConditionConverter.class) {
            if (instance != null) return instance;
            instance = new OracleArgCompareArgConditionConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, ArgCompareArgCondition obj, MybatisParamHolder mybatisParamHolder) {
        Operator operator = obj.getOperator();
        if (operator == Operator.regexp) {
            Operand leftValue = obj.getLeftValue();
            if (leftValue instanceof EntityField) {
                EzMybatisContent.setCurrentAccessField((EntityField)leftValue);
            }
            Converter<?> leftConverter = EzMybatisContent.getConverter(configuration, leftValue.getClass());
            StringBuilder leftSql = new StringBuilder();
            leftSql.append(" REGEXP_LIKE(").append((CharSequence)leftConverter.buildSql(type, new StringBuilder(), configuration, leftValue, mybatisParamHolder)).append(", ");
            Operand value = obj.getRightValue();
            Converter<?> argConverter = EzMybatisContent.getConverter(configuration, value.getClass());
            leftSql.append((CharSequence)argConverter.buildSql(type, new StringBuilder(), configuration, value, mybatisParamHolder)).append(") ");
            return sqlBuilder.append((CharSequence)leftSql);
        }
        return super.doBuildSql(type, sqlBuilder, configuration, obj, mybatisParamHolder);
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.ORACLE;
    }
}

