/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.oracle;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.EzMybatisConfig;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.EzQuery;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.GroupBy;
import org.rdlinux.ezmybatis.core.sqlstruct.OrderBy;
import org.rdlinux.ezmybatis.core.sqlstruct.Page;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.utils.AliasGenerate;

public class OraclePageConverter
extends AbstractConverter<Page>
implements Converter<Page> {
    private static volatile OraclePageConverter instance;

    protected OraclePageConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OraclePageConverter getInstance() {
        if (instance != null) return instance;
        Class<OraclePageConverter> clazz = OraclePageConverter.class;
        synchronized (OraclePageConverter.class) {
            if (instance != null) return instance;
            instance = new OraclePageConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, Page limit, MybatisParamHolder mybatisParamHolder) {
        EzMybatisConfig ezMybatisConfig;
        if (limit == null) {
            return sqlBuilder;
        }
        GroupBy groupBy = null;
        OrderBy orderBy = null;
        EzQuery<?> query = limit.getQuery();
        if (query != null) {
            groupBy = query.getGroupBy();
            orderBy = query.getOrderBy();
        }
        if ((ezMybatisConfig = EzMybatisContent.getContentConfig(configuration).getEzMybatisConfig()).isEnableOracleOffsetFetchPage()) {
            return sqlBuilder.append(" OFFSET ").append(limit.getSkip()).append(" ROWS FETCH NEXT ").append(limit.getSize()).append(" ROWS ONLY ");
        }
        if ((groupBy == null || groupBy.getItems() == null || groupBy.getItems().isEmpty()) && (orderBy == null || orderBy.getItems() == null || orderBy.getItems().isEmpty())) {
            if (limit.getSkip() == 0) {
                return sqlBuilder;
            }
            String bodyAlias = AliasGenerate.getAlias();
            return new StringBuilder("SELECT ").append(bodyAlias).append(".* ").append(" FROM ( ").append((CharSequence)sqlBuilder).append(" ) ").append(bodyAlias).append(" WHERE ").append(bodyAlias).append(".\"").append("ORA_ROWNUM__$").append("\" > ").append(limit.getSkip());
        }
        String bodyAlias = AliasGenerate.getAlias();
        StringBuilder outSqlBuilder = new StringBuilder("SELECT ").append(bodyAlias).append(".*");
        if (limit.getSkip() > 0) {
            outSqlBuilder.append(", ROWNUM \"").append("ORA_ROWNUM__$").append("\"");
        }
        outSqlBuilder.append(" FROM (").append((CharSequence)sqlBuilder).append(") ").append(bodyAlias).append(" WHERE ROWNUM <= ").append(limit.getSkip() + limit.getSize()).append(" ");
        String outAlias = AliasGenerate.getAlias();
        String outSqlHead = "";
        String outSqlTail = "";
        if (limit.getSkip() > 0) {
            outSqlHead = "SELECT " + outAlias + ".* FROM ( ";
            outSqlTail = " ) " + outAlias + " WHERE " + outAlias + ".\"" + "ORA_ROWNUM__$" + "\" > " + limit.getSkip();
        }
        return new StringBuilder().append(outSqlHead).append((CharSequence)outSqlBuilder).append(outSqlTail);
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.ORACLE;
    }
}

