/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.formula;

import java.util.LinkedList;
import java.util.List;
import org.rdlinux.ezmybatis.core.sqlstruct.EntityField;
import org.rdlinux.ezmybatis.core.sqlstruct.Keywords;
import org.rdlinux.ezmybatis.core.sqlstruct.ObjArg;
import org.rdlinux.ezmybatis.core.sqlstruct.Operand;
import org.rdlinux.ezmybatis.core.sqlstruct.QueryRetNeedAlias;
import org.rdlinux.ezmybatis.core.sqlstruct.TableColumn;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.FormulaElement;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.FormulaOperandElement;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.GroupFormulaElement;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EntityTable;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;
import org.rdlinux.ezmybatis.enumeration.FormulaOperator;

public class Formula
implements QueryRetNeedAlias {
    private Table table;
    private List<FormulaElement> elements;

    private Formula() {
    }

    public static FormulaEleBuilder<FormulaBuilder> builder(Table table) {
        LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
        FormulaBuilder formulaBuilder = new FormulaBuilder(table, elements);
        return new FormulaEleBuilder<FormulaBuilder>(formulaBuilder, table, elements);
    }

    public Table getTable() {
        return this.table;
    }

    public List<FormulaElement> getElements() {
        return this.elements;
    }

    public static class FormulaEleBuilder<ParentBuilder> {
        protected ParentBuilder parentBuilder;
        protected List<FormulaElement> elements;
        protected Table table;

        public FormulaEleBuilder(ParentBuilder parentBuilder, Table table, List<FormulaElement> elements) {
            this.parentBuilder = parentBuilder;
            this.table = table;
            this.elements = elements;
        }

        public ParentBuilder done() {
            return this.parentBuilder;
        }

        private void checkEntityTable() {
            if (!(this.table instanceof EntityTable)) {
                throw new IllegalArgumentException("Only EntityTable is supported");
            }
        }

        public FormulaEleBuilder<ParentBuilder> with(Operand value) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.EMPTY, value);
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> withColumn(Table table, String column) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.EMPTY, TableColumn.of(table, column));
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> withColumn(String column) {
            return this.withColumn(this.table, column);
        }

        public FormulaEleBuilder<ParentBuilder> withField(EntityTable table, String field) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.EMPTY, EntityField.of(table, field));
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> withField(String field) {
            this.checkEntityTable();
            return this.withField((EntityTable)this.table, field);
        }

        public FormulaEleBuilder<ParentBuilder> withValue(Object ojb) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.EMPTY, ObjArg.of(ojb));
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> withKeywords(String keywords) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.EMPTY, Keywords.of(keywords));
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return this;
        }

        public FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>> withGroup() {
            LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
            GroupFormulaElement element = new GroupFormulaElement(FormulaOperator.EMPTY, elements);
            if (this.elements.isEmpty()) {
                this.elements.add(element);
            } else {
                this.elements.set(0, element);
            }
            return new FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>>(this, this.table, elements);
        }

        public FormulaEleBuilder<ParentBuilder> add(Operand value) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.ADD, value);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> addColumn(Table table, String column) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.ADD, TableColumn.of(table, column));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> addColumn(String column) {
            return this.addColumn(this.table, column);
        }

        public FormulaEleBuilder<ParentBuilder> addField(EntityTable table, String field) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.ADD, EntityField.of(table, field));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> addField(String field) {
            this.checkEntityTable();
            return this.addField((EntityTable)this.table, field);
        }

        public FormulaEleBuilder<ParentBuilder> addValue(Object ojb) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.ADD, ObjArg.of(ojb));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> addKeywords(String keywords) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.ADD, Keywords.of(keywords));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>> addGroup() {
            LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
            GroupFormulaElement element = new GroupFormulaElement(FormulaOperator.ADD, elements);
            this.elements.add(element);
            return new FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>>(this, this.table, elements);
        }

        public FormulaEleBuilder<ParentBuilder> subtract(Operand value) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.SUBTRACT, value);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> subtractColumn(Table table, String column) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.SUBTRACT, TableColumn.of(table, column));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> subtractColumn(String column) {
            return this.subtractColumn(this.table, column);
        }

        public FormulaEleBuilder<ParentBuilder> subtractField(EntityTable table, String field) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.SUBTRACT, EntityField.of(table, field));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> subtractField(String field) {
            this.checkEntityTable();
            return this.subtractField((EntityTable)this.table, field);
        }

        public FormulaEleBuilder<ParentBuilder> subtractValue(Object ojb) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.SUBTRACT, ObjArg.of(ojb));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> subtractKeywords(String keywords) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.SUBTRACT, Keywords.of(keywords));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>> subtractGroup() {
            LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
            GroupFormulaElement element = new GroupFormulaElement(FormulaOperator.SUBTRACT, elements);
            this.elements.add(element);
            return new FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>>(this, this.table, elements);
        }

        public FormulaEleBuilder<ParentBuilder> multiply(Operand value) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.MULTIPLY, value);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> multiplyColumn(Table table, String column) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.MULTIPLY, TableColumn.of(table, column));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> multiplyColumn(String column) {
            return this.multiplyColumn(this.table, column);
        }

        public FormulaEleBuilder<ParentBuilder> multiplyField(EntityTable table, String field) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.MULTIPLY, EntityField.of(table, field));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> multiplyField(String field) {
            this.checkEntityTable();
            return this.multiplyField((EntityTable)this.table, field);
        }

        public FormulaEleBuilder<ParentBuilder> multiplyValue(Object ojb) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.MULTIPLY, ObjArg.of(ojb));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> multiplyKeywords(String keywords) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.MULTIPLY, Keywords.of(keywords));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>> multiplyGroup() {
            LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
            GroupFormulaElement element = new GroupFormulaElement(FormulaOperator.MULTIPLY, elements);
            this.elements.add(element);
            return new FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>>(this, this.table, elements);
        }

        public FormulaEleBuilder<ParentBuilder> divide(Operand value) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.DIVIDE, value);
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> divideColumn(Table table, String column) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.DIVIDE, TableColumn.of(table, column));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> divideColumn(String column) {
            return this.divideColumn(this.table, column);
        }

        public FormulaEleBuilder<ParentBuilder> divideField(EntityTable table, String field) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.DIVIDE, EntityField.of(table, field));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> divideField(String field) {
            this.checkEntityTable();
            return this.divideField((EntityTable)this.table, field);
        }

        public FormulaEleBuilder<ParentBuilder> divideValue(Object ojb) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.DIVIDE, ObjArg.of(ojb));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<ParentBuilder> divideKeywords(String keywords) {
            FormulaOperandElement element = new FormulaOperandElement(FormulaOperator.DIVIDE, Keywords.of(keywords));
            this.elements.add(element);
            return this;
        }

        public FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>> divideGroup() {
            LinkedList<FormulaElement> elements = new LinkedList<FormulaElement>();
            GroupFormulaElement element = new GroupFormulaElement(FormulaOperator.DIVIDE, elements);
            this.elements.add(element);
            return new FormulaEleBuilder<FormulaEleBuilder<ParentBuilder>>(this, this.table, elements);
        }
    }

    public static class FormulaBuilder {
        private Formula formula = new Formula();

        public FormulaBuilder(Table table, List<FormulaElement> elements) {
            this.formula.table = table;
            this.formula.elements = elements;
        }

        public Formula build() {
            return this.formula;
        }
    }
}

