/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.rdlinux.ezmybatis.EzMybatisConfig;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.interceptor.EzMybatisUpdateInterceptor;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisDeleteListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisInsertListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisOnBuildSqlGetFieldListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisQueryRetListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisUpdateListener;
import org.rdlinux.ezmybatis.core.sqlgenerate.DbKeywordQMFactory;
import org.rdlinux.ezmybatis.utils.Assert;

public class EzContentConfig {
    private List<EzMybatisOnBuildSqlGetFieldListener> onBuildSqlGetFieldListeners;
    private EzMybatisConfig ezMybatisConfig;
    private EzMybatisUpdateInterceptor updateInterceptor;
    private DbKeywordQMFactory dbKeywordQMFactory;
    private DbType dbType;
    private List<EzMybatisInsertListener> insertListeners;
    private List<EzMybatisUpdateListener> updateListeners;
    private List<EzMybatisQueryRetListener> queryRetListeners;

    public void addOnBuildSqlGetFieldListener(EzMybatisOnBuildSqlGetFieldListener listener) {
        if (this.onBuildSqlGetFieldListeners == null) {
            this.onBuildSqlGetFieldListeners = new ArrayList<EzMybatisOnBuildSqlGetFieldListener>();
        }
        this.onBuildSqlGetFieldListeners.add(listener);
        this.onBuildSqlGetFieldListeners.sort(Comparator.comparingInt(EzMybatisOnBuildSqlGetFieldListener::order));
    }

    private void checkUpdateInterceptor() {
        Assert.notNull(this.updateInterceptor, "updateInterceptor can not be null, Please assign a value to updateInterceptor");
    }

    public void addInsertListener(EzMybatisInsertListener listener) {
        this.checkUpdateInterceptor();
        if (this.insertListeners == null) {
            this.insertListeners = new ArrayList<EzMybatisInsertListener>();
        }
        this.insertListeners.add(listener);
        this.insertListeners.sort(Comparator.comparingInt(EzMybatisInsertListener::order));
        this.updateInterceptor.addInsertListener(listener);
    }

    public void addUpdateListener(EzMybatisUpdateListener listener) {
        this.checkUpdateInterceptor();
        if (this.updateListeners == null) {
            this.updateListeners = new ArrayList<EzMybatisUpdateListener>();
        }
        this.updateListeners.add(listener);
        this.updateListeners.sort(Comparator.comparingInt(EzMybatisUpdateListener::order));
        this.updateInterceptor.addUpdateListener(listener);
    }

    public void addQueryRetListener(EzMybatisQueryRetListener listener) {
        this.checkUpdateInterceptor();
        if (this.queryRetListeners == null) {
            this.queryRetListeners = new ArrayList<EzMybatisQueryRetListener>();
        }
        this.queryRetListeners.add(listener);
        this.queryRetListeners.sort(Comparator.comparingInt(EzMybatisQueryRetListener::order));
    }

    public void addDeleteListener(EzMybatisDeleteListener listener) {
        this.checkUpdateInterceptor();
        this.updateInterceptor.addDeleteListener(listener);
    }

    public List<EzMybatisOnBuildSqlGetFieldListener> getOnBuildSqlGetFieldListeners() {
        return this.onBuildSqlGetFieldListeners;
    }

    public EzMybatisConfig getEzMybatisConfig() {
        return this.ezMybatisConfig;
    }

    public EzMybatisUpdateInterceptor getUpdateInterceptor() {
        return this.updateInterceptor;
    }

    public DbKeywordQMFactory getDbKeywordQMFactory() {
        return this.dbKeywordQMFactory;
    }

    public DbType getDbType() {
        return this.dbType;
    }

    public List<EzMybatisInsertListener> getInsertListeners() {
        return this.insertListeners;
    }

    public List<EzMybatisUpdateListener> getUpdateListeners() {
        return this.updateListeners;
    }

    public List<EzMybatisQueryRetListener> getQueryRetListeners() {
        return this.queryRetListeners;
    }

    public EzContentConfig setOnBuildSqlGetFieldListeners(List<EzMybatisOnBuildSqlGetFieldListener> onBuildSqlGetFieldListeners) {
        this.onBuildSqlGetFieldListeners = onBuildSqlGetFieldListeners;
        return this;
    }

    public EzContentConfig setEzMybatisConfig(EzMybatisConfig ezMybatisConfig) {
        this.ezMybatisConfig = ezMybatisConfig;
        return this;
    }

    public EzContentConfig setUpdateInterceptor(EzMybatisUpdateInterceptor updateInterceptor) {
        this.updateInterceptor = updateInterceptor;
        return this;
    }

    public EzContentConfig setDbKeywordQMFactory(DbKeywordQMFactory dbKeywordQMFactory) {
        this.dbKeywordQMFactory = dbKeywordQMFactory;
        return this;
    }

    public EzContentConfig setDbType(DbType dbType) {
        this.dbType = dbType;
        return this;
    }

    public EzContentConfig setInsertListeners(List<EzMybatisInsertListener> insertListeners) {
        this.insertListeners = insertListeners;
        return this;
    }

    public EzContentConfig setUpdateListeners(List<EzMybatisUpdateListener> updateListeners) {
        this.updateListeners = updateListeners;
        return this;
    }

    public EzContentConfig setQueryRetListeners(List<EzMybatisQueryRetListener> queryRetListeners) {
        this.queryRetListeners = queryRetListeners;
        return this;
    }
}

