/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.classinfo;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzContentConfig;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.classinfo.DefaultEzMybatisEntityInfoCache;
import org.rdlinux.ezmybatis.core.classinfo.EzMybatisEntityInfoCache;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.build.DmEntityInfoBuilder;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.build.EntityInfoBuilder;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.build.MySqlEntityInfoBuilder;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.build.OracleEntityInfoBuilder;
import org.rdlinux.ezmybatis.utils.Assert;

public class EzEntityClassInfoFactory {
    private static final Map<DbType, EntityInfoBuilder> ENTITY_INFO_BUILD_MAP = new ConcurrentHashMap<DbType, EntityInfoBuilder>();
    private static EzMybatisEntityInfoCache ENTITY_INFO_CACHE = new DefaultEzMybatisEntityInfoCache();
    private static final ConcurrentMap<String, Object> LOCK_MAP = new ConcurrentHashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityClassInfo forClass(Configuration configuration, Class<?> ntClass) {
        EntityClassInfo result = ENTITY_INFO_CACHE.get(configuration, ntClass);
        if (result == null) {
            Object lockObj;
            String lockKey = configuration.hashCode() + "." + ntClass.hashCode();
            Object object = lockObj = LOCK_MAP.computeIfAbsent(lockKey, k -> new Object());
            synchronized (object) {
                result = ENTITY_INFO_CACHE.get(configuration, ntClass);
                if (result == null) {
                    DbType dbType = EzMybatisContent.getDbType(configuration);
                    EntityInfoBuilder infoBuilder = ENTITY_INFO_BUILD_MAP.get(dbType);
                    EzContentConfig ezContentConfig = EzMybatisContent.getContentConfig(configuration);
                    result = infoBuilder.buildInfo(ezContentConfig, ntClass);
                    ENTITY_INFO_CACHE.set(configuration, result);
                }
            }
            LOCK_MAP.remove(lockKey);
        }
        return result;
    }

    public static void setEntityInfoBuilder(EntityInfoBuilder entityInfoBuilder) {
        Assert.notNull(entityInfoBuilder, "The entity information builder cannot be empty.");
        Assert.notNull(entityInfoBuilder.getSupportedDbType(), "The supported database type cannot be empty.");
        ENTITY_INFO_BUILD_MAP.put(entityInfoBuilder.getSupportedDbType(), entityInfoBuilder);
    }

    public static EntityInfoBuilder getEntityInfoBuilder(Configuration configuration) {
        return ENTITY_INFO_BUILD_MAP.get(EzMybatisContent.getDbType(configuration));
    }

    public static void setEntityInfoCache(EzMybatisEntityInfoCache entityInfoCache) {
        Assert.notNull(entityInfoCache, "The entity information cache cannot be null.");
        ENTITY_INFO_CACHE = entityInfoCache;
    }

    static {
        MySqlEntityInfoBuilder mySqlEntityInfoBuild = MySqlEntityInfoBuilder.getInstance();
        ENTITY_INFO_BUILD_MAP.put(mySqlEntityInfoBuild.getSupportedDbType(), mySqlEntityInfoBuild);
        OracleEntityInfoBuilder oracleEntityInfoBuild = OracleEntityInfoBuilder.getInstance();
        ENTITY_INFO_BUILD_MAP.put(oracleEntityInfoBuild.getSupportedDbType(), oracleEntityInfoBuild);
        DmEntityInfoBuilder dmEntityInfoBuild = DmEntityInfoBuilder.getInstance();
        ENTITY_INFO_BUILD_MAP.put(dmEntityInfoBuild.getSupportedDbType(), dmEntityInfoBuild);
        ENTITY_INFO_BUILD_MAP.put(DbType.POSTGRE_SQL, mySqlEntityInfoBuild);
        ENTITY_INFO_BUILD_MAP.put(DbType.SQL_SERVER, mySqlEntityInfoBuild);
    }
}

