/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlgenerate;

import java.util.HashMap;
import java.util.Map;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.sqlgenerate.SqlGenerate;
import org.rdlinux.ezmybatis.core.sqlgenerate.dm.DmSqlGenerate;
import org.rdlinux.ezmybatis.core.sqlgenerate.mssql.SqlServerSqlGenerate;
import org.rdlinux.ezmybatis.core.sqlgenerate.mysql.MySqlSqlGenerate;
import org.rdlinux.ezmybatis.core.sqlgenerate.oracle.OracleSqlGenerate;
import org.rdlinux.ezmybatis.core.sqlgenerate.postgre.PostgreSqlGenerate;

public class SqlGenerateFactory {
    private static final Map<DbType, SqlGenerate> sqlGenerateMap = new HashMap<DbType, SqlGenerate>();

    public static SqlGenerate getSqlGenerate(DbType dbType) {
        return sqlGenerateMap.get(dbType);
    }

    static {
        sqlGenerateMap.put(DbType.MYSQL, MySqlSqlGenerate.getInstance());
        sqlGenerateMap.put(DbType.ORACLE, OracleSqlGenerate.getInstance());
        sqlGenerateMap.put(DbType.DM, DmSqlGenerate.getInstance());
        sqlGenerateMap.put(DbType.POSTGRE_SQL, PostgreSqlGenerate.getInstance());
        sqlGenerateMap.put(DbType.SQL_SERVER, SqlServerSqlGenerate.getInstance());
    }
}

