/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct;

import java.util.LinkedList;
import java.util.List;
import org.rdlinux.ezmybatis.core.sqlstruct.EntityField;
import org.rdlinux.ezmybatis.core.sqlstruct.Function;
import org.rdlinux.ezmybatis.core.sqlstruct.Keywords;
import org.rdlinux.ezmybatis.core.sqlstruct.ObjArg;
import org.rdlinux.ezmybatis.core.sqlstruct.Operand;
import org.rdlinux.ezmybatis.core.sqlstruct.QueryRetNeedAlias;
import org.rdlinux.ezmybatis.core.sqlstruct.TableColumn;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.ConditionBuilder;
import org.rdlinux.ezmybatis.core.sqlstruct.formula.Formula;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EntityTable;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;
import org.rdlinux.ezmybatis.utils.Assert;

public class CaseWhen
implements QueryRetNeedAlias {
    private Table table;
    private List<CaseWhenData> caseWhenData;
    private CaseWhenData els;

    private CaseWhen(Table table) {
        this.table = table;
    }

    public static CaseWhenBuilder builder(Table table) {
        return new CaseWhenBuilder(table);
    }

    public Table getTable() {
        return this.table;
    }

    public List<CaseWhenData> getCaseWhenData() {
        return this.caseWhenData;
    }

    public CaseWhenData getEls() {
        return this.els;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setCaseWhenData(List<CaseWhenData> caseWhenData) {
        this.caseWhenData = caseWhenData;
    }

    public void setEls(CaseWhenData els) {
        this.els = els;
    }

    public static class CaseWhenBuilder {
        protected Table table;
        protected CaseWhen caseWhen;

        private CaseWhenBuilder(Table table) {
            this.table = table;
            this.caseWhen = new CaseWhen(table);
        }

        public CaseWhenData.CaseWhenDataBuilder when() {
            if (this.caseWhen.getCaseWhenData() == null) {
                this.caseWhen.setCaseWhenData(new LinkedList<CaseWhenData>());
            }
            CaseWhenData caseWhenData = new CaseWhenData();
            caseWhenData.setConditions(new LinkedList<Condition>());
            this.caseWhen.getCaseWhenData().add(caseWhenData);
            return new CaseWhenData.CaseWhenDataBuilder(this.table, this, caseWhenData);
        }

        public CaseWhen els(Object value) {
            this.caseWhen.setEls(new CaseWhenData().setValue(ObjArg.of(value)));
            return this.caseWhen;
        }

        public CaseWhen elsKeywords(String keywords) {
            this.caseWhen.setEls(new CaseWhenData().setValue(Keywords.of(keywords)));
            return this.caseWhen;
        }

        public CaseWhen elsColumn(Table table, String column) {
            Assert.notNull(table, "table can not be null");
            Assert.notEmpty(column, "column can not be null");
            this.caseWhen.setEls(new CaseWhenData().setTable(table).setValue(TableColumn.of(table, column)));
            return this.caseWhen;
        }

        public CaseWhen elsColumn(String column) {
            return this.elsColumn(this.table, column);
        }

        public CaseWhen elsField(EntityTable table, String field) {
            Assert.notNull(table, "table can not be null");
            Assert.notEmpty(field, "field can not be null");
            this.caseWhen.setEls(new CaseWhenData().setTable(table).setValue(EntityField.of(table, field)));
            return this.caseWhen;
        }

        public CaseWhen elsField(String field) {
            this.checkEntityTable();
            return this.elsField((EntityTable)this.table, field);
        }

        public CaseWhen elsFunc(Function function) {
            Assert.notNull(function, "function can not be null");
            this.caseWhen.setEls(new CaseWhenData().setValue(function));
            return this.caseWhen;
        }

        public CaseWhen elsFormula(Formula formula) {
            Assert.notNull(formula, "formula can not be null");
            this.caseWhen.setEls(new CaseWhenData().setValue(formula));
            return this.caseWhen;
        }

        public CaseWhen elsCaseWhen(CaseWhen caseWhen) {
            Assert.notNull(caseWhen, "caseWhen can not be null");
            this.caseWhen.setEls(new CaseWhenData().setValue(caseWhen));
            return this.caseWhen;
        }

        public CaseWhen els(Operand value) {
            this.caseWhen.setEls(new CaseWhenData().setValue(value));
            return this.caseWhen;
        }

        private void checkEntityTable() {
            if (!(this.table instanceof EntityTable)) {
                throw new IllegalArgumentException("Only EntityTable is supported");
            }
        }

        public CaseWhen build() {
            return this.caseWhen;
        }
    }

    public static class CaseWhenData {
        private List<Condition> conditions;
        private Table table;
        private Operand value;

        public CaseWhenData setValue(Operand value) {
            if (value == null) {
                value = ObjArg.of(value);
            }
            this.value = value;
            return this;
        }

        public List<Condition> getConditions() {
            return this.conditions;
        }

        public Table getTable() {
            return this.table;
        }

        public Operand getValue() {
            return this.value;
        }

        public CaseWhenData setConditions(List<Condition> conditions) {
            this.conditions = conditions;
            return this;
        }

        public CaseWhenData setTable(Table table) {
            this.table = table;
            return this;
        }

        public static class CaseWhenDataBuilder
        extends ConditionBuilder<CaseWhenBuilder, CaseWhenDataBuilder> {
            private CaseWhenData caseWhenData;

            public CaseWhenDataBuilder(Table table, CaseWhenBuilder caseWhenBuilder, CaseWhenData caseWhenData) {
                super(caseWhenBuilder, caseWhenData.getConditions(), table, table);
                this.sonBuilder = this;
                this.caseWhenData = caseWhenData;
            }

            public CaseWhenBuilder then(Object value) {
                this.caseWhenData.setValue(ObjArg.of(value));
                return (CaseWhenBuilder)this.parentBuilder;
            }

            public CaseWhenBuilder thenKeywords(String keywords) {
                Assert.notEmpty(keywords, keywords);
                this.caseWhenData.setValue(Keywords.of(keywords));
                return (CaseWhenBuilder)this.parentBuilder;
            }

            public CaseWhenBuilder thenColumn(Table table, String column) {
                Assert.notNull(table, "table can not be null");
                Assert.notEmpty(column, "column can not be null");
                this.caseWhenData.setTable(table).setValue(TableColumn.of(table, column));
                return (CaseWhenBuilder)this.parentBuilder;
            }

            public CaseWhenBuilder thenColumn(String column) {
                return this.thenColumn(this.table, column);
            }

            public CaseWhenBuilder thenField(EntityTable table, String field) {
                Assert.notNull(table, "table can not be null");
                Assert.notEmpty(field, "field can not be null");
                this.caseWhenData.setTable(table).setValue(EntityField.of(table, field));
                return (CaseWhenBuilder)this.parentBuilder;
            }

            public CaseWhenBuilder thenField(String field) {
                this.checkEntityTable();
                return this.thenField((EntityTable)this.table, field);
            }

            public CaseWhenBuilder thenFunc(Function function) {
                Assert.notNull(function, "function can not be null");
                this.caseWhenData.setValue(function);
                return (CaseWhenBuilder)this.parentBuilder;
            }

            public CaseWhenBuilder thenFormula(Formula formula) {
                Assert.notNull(formula, "formula can not be null");
                this.caseWhenData.setValue(formula);
                return (CaseWhenBuilder)this.parentBuilder;
            }

            public CaseWhenBuilder thenCaseWhen(CaseWhen caseWhen) {
                Assert.notNull(caseWhen, "caseWhen can not be null");
                this.caseWhenData.setValue(caseWhen);
                return (CaseWhenBuilder)this.parentBuilder;
            }

            public CaseWhenBuilder then(Operand value) {
                this.caseWhenData.setValue(value);
                return (CaseWhenBuilder)this.parentBuilder;
            }
        }
    }
}

