/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mssql;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.classinfo.EzEntityClassInfoFactory;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityFieldInfo;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.EntityField;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.utils.Assert;

public class SqlServerEntityFieldConverter
extends AbstractConverter<EntityField>
implements Converter<EntityField> {
    private static volatile SqlServerEntityFieldConverter instance;

    protected SqlServerEntityFieldConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlServerEntityFieldConverter getInstance() {
        if (instance != null) return instance;
        Class<SqlServerEntityFieldConverter> clazz = SqlServerEntityFieldConverter.class;
        synchronized (SqlServerEntityFieldConverter.class) {
            if (instance != null) return instance;
            instance = new SqlServerEntityFieldConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, EntityField obj, MybatisParamHolder mybatisParamHolder) {
        EntityClassInfo etInfo = EzEntityClassInfoFactory.forClass(configuration, obj.getTable().getEtType());
        EntityFieldInfo fieldInfo = etInfo.getFieldInfo(obj.getField());
        Assert.notNull(fieldInfo, "Class " + etInfo.getEntityClass().getName() + "cannot find the filed " + obj.getField());
        String keywordQM = EzMybatisContent.getKeywordQM(configuration);
        if (type == Converter.Type.SELECT) {
            sqlBuilder.append(obj.getTable().getAlias()).append(".");
        }
        return sqlBuilder.append(keywordQM).append(fieldInfo.getColumnName()).append(keywordQM);
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.SQL_SERVER;
    }
}

