/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import java.util.List;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.Function;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.utils.SqlEscaping;

public class MySqlFunctionConverter
extends AbstractConverter<Function>
implements Converter<Function> {
    private static volatile MySqlFunctionConverter instance;

    protected MySqlFunctionConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlFunctionConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlFunctionConverter> clazz = MySqlFunctionConverter.class;
        synchronized (MySqlFunctionConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlFunctionConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, Function ojb, MybatisParamHolder mybatisParamHolder) {
        sqlBuilder.append(" ").append(SqlEscaping.nameEscaping(ojb.getFunName())).append("(");
        List<Function.FunArg> funArgs = ojb.getFunArgs();
        if (funArgs != null && !funArgs.isEmpty()) {
            for (int i = 0; i < funArgs.size(); ++i) {
                Function.FunArg arg = funArgs.get(i);
                if (arg.isDistinct()) {
                    sqlBuilder.append(" DISTINCT ");
                }
                Converter<?> converter = EzMybatisContent.getConverter(configuration, arg.getArgValue().getClass());
                converter.buildSql(type, sqlBuilder, configuration, arg.getArgValue(), mybatisParamHolder);
                if (i + 1 >= funArgs.size()) continue;
                sqlBuilder.append(", ");
            }
        }
        sqlBuilder.append(") ");
        return sqlBuilder;
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

