/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.Join;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql.MySqlWhereConverter;
import org.rdlinux.ezmybatis.enumeration.JoinType;

public class MySqlJoinConverter
extends AbstractConverter<Join>
implements Converter<Join> {
    private static volatile MySqlJoinConverter instance;

    protected MySqlJoinConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlJoinConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlJoinConverter> clazz = MySqlJoinConverter.class;
        synchronized (MySqlJoinConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlJoinConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, Join join, MybatisParamHolder mybatisParamHolder) {
        if (join == null) {
            return sqlBuilder;
        }
        if (!join.isSure()) {
            return sqlBuilder;
        }
        String sonSql = "";
        if (join.getJoinType() != JoinType.CrossJoin && StringUtils.isBlank((CharSequence)(sonSql = MySqlWhereConverter.conditionsToSql(type, new StringBuilder(), configuration, mybatisParamHolder, join.getOnConditions()).toString()))) {
            return sqlBuilder;
        }
        Converter<?> joinTableConverter = EzMybatisContent.getConverter(configuration, join.getJoinTable().getClass());
        sqlBuilder.append(join.getJoinType().toSqlStruct());
        sqlBuilder = joinTableConverter.buildSql(type, sqlBuilder, configuration, join.getJoinTable(), mybatisParamHolder);
        if (join.getJoinType() != JoinType.CrossJoin) {
            sqlBuilder.append(" ON ");
        }
        sqlBuilder.append(sonSql);
        if (join.getJoins() != null && !join.getJoins().isEmpty()) {
            for (Join sonJoin : join.getJoins()) {
                sqlBuilder.append((CharSequence)this.doBuildSql(type, new StringBuilder(), configuration, sonJoin, mybatisParamHolder));
            }
        }
        return sqlBuilder;
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

