/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.table.partition.NormalPartition;
import org.rdlinux.ezmybatis.utils.SqlEscaping;

public class MySqlNormalPartitionConverter
extends AbstractConverter<NormalPartition>
implements Converter<NormalPartition> {
    private static volatile MySqlNormalPartitionConverter instance;

    protected MySqlNormalPartitionConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlNormalPartitionConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlNormalPartitionConverter> clazz = MySqlNormalPartitionConverter.class;
        synchronized (MySqlNormalPartitionConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlNormalPartitionConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, NormalPartition partition, MybatisParamHolder mybatisParamHolder) {
        if (partition == null || partition.getPartitions() == null || partition.getPartitions().isEmpty()) {
            return sqlBuilder;
        }
        for (int i = 0; i < partition.getPartitions().size(); ++i) {
            sqlBuilder.append(SqlEscaping.nameEscaping(partition.getPartitions().get(i)));
            if (i + 1 >= partition.getPartitions().size()) continue;
            sqlBuilder.append(", ");
        }
        sqlBuilder.append(") ");
        return sqlBuilder;
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

