/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import java.lang.reflect.Field;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.classinfo.EzEntityClassInfoFactory;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityFieldInfo;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.EntityField;
import org.rdlinux.ezmybatis.core.sqlstruct.ObjArg;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;

public class MySqlObjArgConverter
extends AbstractConverter<ObjArg>
implements Converter<ObjArg> {
    private static volatile MySqlObjArgConverter instance;

    protected MySqlObjArgConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlObjArgConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlObjArgConverter> clazz = MySqlObjArgConverter.class;
        synchronized (MySqlObjArgConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlObjArgConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, ObjArg obj, MybatisParamHolder mybatisParamHolder) {
        Class<?> modelType = null;
        Field field = null;
        EntityField currentAccessField = EzMybatisContent.getCurrentAccessField();
        if (currentAccessField != null) {
            EntityFieldInfo fieldInfo;
            modelType = currentAccessField.getTable().getEtType();
            EntityClassInfo etInfo = EzEntityClassInfoFactory.forClass(configuration, currentAccessField.getTable().getEtType());
            if (etInfo != null && (fieldInfo = etInfo.getFieldInfo(currentAccessField.getField())) != null) {
                field = fieldInfo.getField();
            }
        }
        String paramName = mybatisParamHolder.getMybatisParamName(modelType, field, obj.getArg());
        return sqlBuilder.append(paramName);
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

