/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.classinfo.EzEntityClassInfoFactory;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityFieldInfo;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.selectitem.SelectTableAllItem;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EntityTable;
import org.rdlinux.ezmybatis.utils.Assert;
import org.rdlinux.ezmybatis.utils.SqlEscaping;

public class MySqlSelectTableAllItemConverter
extends AbstractConverter<SelectTableAllItem>
implements Converter<SelectTableAllItem> {
    private static volatile MySqlSelectTableAllItemConverter instance;

    protected MySqlSelectTableAllItemConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlSelectTableAllItemConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlSelectTableAllItemConverter> clazz = MySqlSelectTableAllItemConverter.class;
        synchronized (MySqlSelectTableAllItemConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlSelectTableAllItemConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, SelectTableAllItem ojb, MybatisParamHolder mybatisParamHolder) {
        boolean execExcludeField = false;
        if (ojb.getTable() instanceof EntityTable && ojb.getExcludeField() != null && ojb.getExcludeField().size() > 0) {
            execExcludeField = true;
        }
        if (execExcludeField) {
            EntityTable table = (EntityTable)ojb.getTable();
            EntityClassInfo entityClassInfo = EzEntityClassInfoFactory.forClass(configuration, table.getEtType());
            List<EntityFieldInfo> fieldInfos = entityClassInfo.getFieldInfos();
            fieldInfos = fieldInfos.stream().filter(e -> !ojb.getExcludeField().contains(e.getFieldName())).collect(Collectors.toList());
            Assert.notEmpty(fieldInfos, "No valid select item");
            String keywordQM = EzMybatisContent.getKeywordQM(configuration);
            for (int i = 0; i < fieldInfos.size(); ++i) {
                EntityFieldInfo fieldInfo = fieldInfos.get(i);
                sqlBuilder.append(" ").append(ojb.getTable().getAlias()).append(".").append(keywordQM).append(SqlEscaping.nameEscaping(fieldInfo.getColumnName())).append(keywordQM);
                if (i + 1 < fieldInfos.size()) {
                    sqlBuilder.append(", ");
                    continue;
                }
                sqlBuilder.append(" ");
            }
            return sqlBuilder;
        }
        return sqlBuilder.append(" ").append(ojb.getTable().getAlias()).append(".* ");
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

