/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlgenerate.SqlGenerateFactory;
import org.rdlinux.ezmybatis.core.sqlstruct.Union;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.utils.AliasGenerate;

public class MySqlUnionConverter
extends AbstractConverter<Union>
implements Converter<Union> {
    private static volatile MySqlUnionConverter instance;

    protected MySqlUnionConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlUnionConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlUnionConverter> clazz = MySqlUnionConverter.class;
        synchronized (MySqlUnionConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlUnionConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, Union obj, MybatisParamHolder mybatisParamHolder) {
        if (obj.getQuery() == null) {
            return sqlBuilder;
        }
        sqlBuilder.append(" UNION ");
        if (obj.isAll()) {
            sqlBuilder.append(" ALL ");
        }
        sqlBuilder.append("\n(");
        String unionSql = SqlGenerateFactory.getSqlGenerate(EzMybatisContent.getDbType(configuration)).getQuerySql(configuration, mybatisParamHolder, obj.getQuery());
        if (obj.getQuery().getOrderBy() != null) {
            unionSql = String.format("SELECT * FROM (%s) %s", unionSql, AliasGenerate.getAlias());
        }
        sqlBuilder.append(unionSql).append(") ");
        return sqlBuilder;
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

