/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.core.sqlstruct.converter.mysql;

import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.classinfo.EzEntityClassInfoFactory;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityClassInfo;
import org.rdlinux.ezmybatis.core.classinfo.entityinfo.EntityFieldInfo;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.EntityField;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.update.UpdateFieldItem;
import org.rdlinux.ezmybatis.utils.SqlEscaping;

public class MySqlUpdateFieldItemConverter
extends AbstractConverter<UpdateFieldItem>
implements Converter<UpdateFieldItem> {
    private static volatile MySqlUpdateFieldItemConverter instance;

    protected MySqlUpdateFieldItemConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MySqlUpdateFieldItemConverter getInstance() {
        if (instance != null) return instance;
        Class<MySqlUpdateFieldItemConverter> clazz = MySqlUpdateFieldItemConverter.class;
        synchronized (MySqlUpdateFieldItemConverter.class) {
            if (instance != null) return instance;
            instance = new MySqlUpdateFieldItemConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected boolean appendAlias() {
        return true;
    }

    @Override
    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, UpdateFieldItem obj, MybatisParamHolder mybatisParamHolder) {
        String keywordQM = EzMybatisContent.getKeywordQM(configuration);
        EntityClassInfo etInfo = EzEntityClassInfoFactory.forClass(configuration, obj.getEntityTable().getEtType());
        EntityFieldInfo fieldInfo = etInfo.getFieldInfo(obj.getField());
        EzMybatisContent.setCurrentAccessField(EntityField.of(obj.getEntityTable(), obj.getField()));
        Converter<?> argConverter = EzMybatisContent.getConverter(configuration, obj.getValue().getClass());
        StringBuilder valueSql = argConverter.buildSql(type, new StringBuilder(), configuration, obj.getValue(), mybatisParamHolder);
        if (this.appendAlias()) {
            sqlBuilder.append(obj.getTable().getAlias()).append(".");
        }
        String column = fieldInfo.getColumnName();
        sqlBuilder.append(keywordQM).append(SqlEscaping.nameEscaping(column)).append(keywordQM).append(" = ").append((CharSequence)valueSql);
        EzMybatisContent.cleanCurrentAccessField();
        return sqlBuilder;
    }

    @Override
    public DbType getSupportDbType() {
        return DbType.MYSQL;
    }
}

