/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.expand.oracle.converter;

import java.util.List;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlgenerate.MybatisParamHolder;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.AbstractConverter;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.update.UpdateItem;
import org.rdlinux.ezmybatis.expand.oracle.update.Merge;

public class OracleMergeConverter
extends AbstractConverter<Merge>
implements Converter<Merge> {
    private static volatile OracleMergeConverter instance;

    protected OracleMergeConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OracleMergeConverter getInstance() {
        if (instance != null) return instance;
        Class<OracleMergeConverter> clazz = OracleMergeConverter.class;
        synchronized (OracleMergeConverter.class) {
            if (instance != null) return instance;
            instance = new OracleMergeConverter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected static void conditionsToSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, MybatisParamHolder mybatisParamHolder, List<Condition> conditions) {
        boolean lastConditionEmpty = true;
        for (Condition condition : conditions) {
            Converter converter = EzMybatisContent.getConverter((Configuration)configuration, condition.getClass());
            String sqlPart = converter.buildSql(type, new StringBuilder(), configuration, (Object)condition, mybatisParamHolder).toString();
            boolean emptySql = sqlPart.trim().isEmpty();
            if (!lastConditionEmpty && !emptySql) {
                sqlBuilder.append(condition.getAndOr().name()).append(" ");
            }
            if (!emptySql) {
                lastConditionEmpty = false;
                sqlBuilder.append(sqlPart);
                continue;
            }
            lastConditionEmpty = true;
        }
    }

    protected StringBuilder doBuildSql(Converter.Type type, StringBuilder sqlBuilder, Configuration configuration, Merge merge, MybatisParamHolder mybatisParamHolder) {
        String keywordQM = EzMybatisContent.getKeywordQM((Configuration)configuration);
        sqlBuilder.append(" MERGE INTO ").append(keywordQM).append(merge.getMergeTable().getTableName(configuration)).append(keywordQM).append(" ").append(merge.getMergeTable().getAlias()).append(" USING ");
        Converter tableConverter = EzMybatisContent.getConverter((Configuration)configuration, merge.getUseTable().getClass());
        tableConverter.buildSql(type, sqlBuilder, configuration, (Object)merge.getUseTable(), mybatisParamHolder);
        sqlBuilder.append(" ON ( ");
        OracleMergeConverter.conditionsToSql(type, sqlBuilder, configuration, mybatisParamHolder, merge.getOn());
        sqlBuilder.append(" ) WHEN MATCHED THEN UPDATE SET ");
        List items = merge.getSet().getItems();
        for (int i = 0; i < items.size(); ++i) {
            UpdateItem updateItem = (UpdateItem)items.get(i);
            Converter converter = EzMybatisContent.getConverter((Configuration)configuration, updateItem.getClass());
            sqlBuilder = converter.buildSql(type, sqlBuilder, configuration, (Object)updateItem, mybatisParamHolder);
            if (i + 1 >= items.size()) continue;
            sqlBuilder.append(", ");
        }
        return sqlBuilder;
    }

    public DbType getSupportDbType() {
        return DbType.DM;
    }
}

