/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.expand.oracle.update;

import java.util.LinkedList;
import java.util.List;
import org.rdlinux.ezmybatis.constant.DbType;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.sqlstruct.SqlExpand;
import org.rdlinux.ezmybatis.core.sqlstruct.UpdateSet;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.Condition;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.ConditionBuilder;
import org.rdlinux.ezmybatis.core.sqlstruct.condition.GroupCondition;
import org.rdlinux.ezmybatis.core.sqlstruct.converter.Converter;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EzQueryTable;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;
import org.rdlinux.ezmybatis.core.sqlstruct.update.UpdateSetBuilder;
import org.rdlinux.ezmybatis.enumeration.AndOr;
import org.rdlinux.ezmybatis.expand.oracle.converter.OracleMergeConverter;

public class Merge
implements SqlExpand {
    private Table mergeTable;
    private EzQueryTable useTable;
    private List<Condition> on;
    private UpdateSet set;

    private Merge() {
    }

    public static MergeBuilder into(Table table) {
        return new MergeBuilder(table);
    }

    public Table getMergeTable() {
        return this.mergeTable;
    }

    public EzQueryTable getUseTable() {
        return this.useTable;
    }

    public List<Condition> getOn() {
        return this.on;
    }

    public UpdateSet getSet() {
        return this.set;
    }

    static {
        EzMybatisContent.addConverter((DbType)DbType.ORACLE, Merge.class, (Converter)OracleMergeConverter.getInstance());
        EzMybatisContent.addConverter((DbType)DbType.DM, Merge.class, (Converter)OracleMergeConverter.getInstance());
    }

    public static class MergeBuilder {
        private Merge merge = new Merge();

        private MergeBuilder(Table table) {
            this.merge.mergeTable = table;
            this.merge.set = new UpdateSet();
        }

        public MergeBuilder using(EzQueryTable table) {
            this.merge.useTable = table;
            return this;
        }

        public MergeOnBuilder<MergeBuilder> on(Table table) {
            if (this.merge.useTable == null) {
                throw new IllegalArgumentException("Please use the 'using' method to initialize the table being used first.");
            }
            if (this.merge.on == null) {
                this.merge.on = new LinkedList();
            }
            return new MergeOnBuilder<MergeBuilder>(this, this.merge.on, table, this.merge.useTable);
        }

        public MergeOnBuilder<MergeBuilder> on() {
            return this.on(this.merge.mergeTable);
        }

        public UpdateSetBuilder<MergeBuilder> set() {
            return new UpdateSetBuilder((Object)this, this.merge.mergeTable, this.merge.set);
        }

        public Merge build() {
            return this.merge;
        }

        public static class MergeOnBuilder<Builder>
        extends ConditionBuilder<Builder, MergeOnBuilder<Builder>> {
            private MergeOnBuilder(Builder builder, List<Condition> on, Table mergeTable, EzQueryTable useTable) {
                super(builder, on, mergeTable, (Table)useTable);
                this.sonBuilder = this;
            }

            public MergeOnBuilder<MergeOnBuilder<Builder>> groupCondition(boolean sure, AndOr andOr) {
                GroupCondition condition = new GroupCondition(sure, new LinkedList(), andOr);
                this.conditions.add(condition);
                return new MergeOnBuilder<MergeOnBuilder<Builder>>(this, condition.getConditions(), this.table, (EzQueryTable)this.otherTable);
            }

            public MergeOnBuilder<MergeOnBuilder<Builder>> groupCondition(AndOr andOr) {
                return this.groupCondition(true, andOr);
            }

            public MergeOnBuilder<MergeOnBuilder<Builder>> groupCondition(boolean sure) {
                return this.groupCondition(sure, AndOr.AND);
            }

            public MergeOnBuilder<MergeOnBuilder<Builder>> groupCondition() {
                return this.groupCondition(true);
            }
        }
    }
}

