/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.spring;

import java.util.Comparator;
import java.util.Map;
import org.apache.ibatis.session.Configuration;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisDeleteListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisInsertListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisUpdateListener;
import org.rdlinux.ezmybatis.utils.Assert;
import org.springframework.context.ApplicationContext;

public class SpringEzMybatisInit {
    public static void init(Configuration configuration, ApplicationContext applicationContext) {
        Assert.notNull((Object)configuration, (String)"configuration can not be null");
        Assert.notNull((Object)applicationContext, (String)"applicationContext can not be null");
        EzMybatisContent.init((Configuration)configuration);
        Map insertListenerMap = applicationContext.getBeansOfType(EzMybatisInsertListener.class);
        insertListenerMap.values().stream().sorted(Comparator.comparingInt(EzMybatisInsertListener::order)).forEach(e -> EzMybatisContent.addInsertListener((Configuration)configuration, (EzMybatisInsertListener)e));
        Map updateListenerMap = applicationContext.getBeansOfType(EzMybatisUpdateListener.class);
        updateListenerMap.values().stream().sorted(Comparator.comparingInt(EzMybatisUpdateListener::order)).forEach(e -> EzMybatisContent.addUpdateListener((Configuration)configuration, (EzMybatisUpdateListener)e));
        Map deleteListenerMap = applicationContext.getBeansOfType(EzMybatisDeleteListener.class);
        deleteListenerMap.values().stream().sorted(Comparator.comparingInt(EzMybatisDeleteListener::order)).forEach(e -> EzMybatisContent.addDeleteListener((Configuration)configuration, (EzMybatisDeleteListener)e));
    }
}

