/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.spring;

import java.util.Comparator;
import java.util.Map;
import org.rdlinux.ezmybatis.EzMybatisConfig;
import org.rdlinux.ezmybatis.core.EzMybatisContent;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisDeleteListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisInsertListener;
import org.rdlinux.ezmybatis.core.interceptor.listener.EzMybatisUpdateListener;
import org.rdlinux.ezmybatis.spring.EzMybatisInitListener;
import org.rdlinux.ezmybatis.utils.Assert;
import org.springframework.context.ApplicationContext;

public class SpringEzMybatisInit {
    public static void init(EzMybatisConfig ezMybatisConfig, ApplicationContext applicationContext) {
        Assert.notNull((Object)ezMybatisConfig, (String)"ezMybatisConfig can not be null");
        Assert.notNull((Object)applicationContext, (String)"applicationContext can not be null");
        EzMybatisContent.init((EzMybatisConfig)ezMybatisConfig);
        Map insertListenerMap = applicationContext.getBeansOfType(EzMybatisInsertListener.class);
        insertListenerMap.values().stream().sorted(Comparator.comparingInt(EzMybatisInsertListener::order)).forEach(e -> EzMybatisContent.addInsertListener((EzMybatisConfig)ezMybatisConfig, (EzMybatisInsertListener)e));
        Map updateListenerMap = applicationContext.getBeansOfType(EzMybatisUpdateListener.class);
        updateListenerMap.values().stream().sorted(Comparator.comparingInt(EzMybatisUpdateListener::order)).forEach(e -> EzMybatisContent.addUpdateListener((EzMybatisConfig)ezMybatisConfig, (EzMybatisUpdateListener)e));
        Map deleteListenerMap = applicationContext.getBeansOfType(EzMybatisDeleteListener.class);
        deleteListenerMap.values().stream().sorted(Comparator.comparingInt(EzMybatisDeleteListener::order)).forEach(e -> EzMybatisContent.addDeleteListener((EzMybatisConfig)ezMybatisConfig, (EzMybatisDeleteListener)e));
        Map initListenerMap = applicationContext.getBeansOfType(EzMybatisInitListener.class);
        initListenerMap.values().stream().sorted(Comparator.comparingInt(EzMybatisInitListener::order)).forEach(e -> e.onDone(ezMybatisConfig));
    }
}

