/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezmybatis.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.rdlinux.ezmybatis.core.EzDelete;
import org.rdlinux.ezmybatis.core.EzQuery;
import org.rdlinux.ezmybatis.core.dao.JdbcInsertDao;
import org.rdlinux.ezmybatis.core.mapper.EzMapper;
import org.rdlinux.ezmybatis.core.sqlstruct.Where;
import org.rdlinux.ezmybatis.core.sqlstruct.table.EntityTable;
import org.rdlinux.ezmybatis.core.sqlstruct.table.Table;
import org.rdlinux.ezmybatis.service.EzService;
import org.rdlinux.ezmybatis.utils.Assert;
import org.rdlinux.ezmybatis.utils.ReflectionUtils;

public abstract class EzServiceImpl<MdType, PkType extends Serializable>
implements EzService<MdType, PkType> {
    @Resource
    protected EzMapper ezMapper;
    @Resource
    protected JdbcInsertDao jdbcBatchInsertDao;
    private Class<?> modelClass = ReflectionUtils.getGenericSuperclass(this.getClass(), (int)0);

    @Override
    public List<MdType> query(EzQuery<MdType> param) {
        Assert.notNull(param, (String)"param can not be null");
        return this.ezMapper.query(param);
    }

    @Override
    public int queryCount(EzQuery<MdType> param) {
        Assert.notNull(param, (String)"param can not be null");
        return this.ezMapper.queryCount(param);
    }

    @Override
    public MdType getById(PkType id) {
        Assert.notNull(id, (String)"id can not be null");
        return (MdType)this.ezMapper.selectById(this.modelClass, id);
    }

    @Override
    public MdType getById(Table table, PkType id) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull(id, (String)"id can not be null");
        return (MdType)this.ezMapper.selectByTableAndId(table, this.modelClass, id);
    }

    @Override
    public List<MdType> getByIds(Collection<PkType> ids) {
        Assert.notEmpty(ids, (String)"ids can not be null");
        return this.ezMapper.selectByIds(this.modelClass, ids);
    }

    @Override
    public List<MdType> getByIds(Table table, Collection<PkType> ids) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notEmpty(ids, (String)"ids can not be null");
        return this.ezMapper.selectByTableAndIds(table, this.modelClass, ids);
    }

    @Override
    public List<MdType> getByField(String field, Object value) {
        return this.getByField((Table)EntityTable.of(this.modelClass), field, value);
    }

    @Override
    public List<MdType> getByField(Table table, String field, Object value) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull((Object)field, (String)"field can not be null");
        Assert.notNull((Object)value, (String)"value can not be null");
        EzQuery query = ((EzQuery.EzQueryBuilder)((Where.WhereBuilder)((EzQuery.EzQueryBuilder)EzQuery.builder(this.modelClass).from(table).select().addAll(new String[0]).done()).where().addFieldCondition(field, value)).done()).build();
        return this.ezMapper.query(query);
    }

    @Override
    public MdType getOneByField(String field, Object value) {
        return this.getOneByField((Table)EntityTable.of(this.modelClass), field, value);
    }

    @Override
    public MdType getOneByField(Table table, String field, Object value) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull((Object)field, (String)"field can not be null");
        Assert.notNull((Object)value, (String)"value can not be null");
        Class<?> modelClass = this.modelClass;
        EzQuery query = ((EzQuery.EzQueryBuilder)((Where.WhereBuilder)((EzQuery.EzQueryBuilder)EzQuery.builder(modelClass).from(table).select().addAll(new String[0]).done()).where().addFieldCondition(field, value)).done()).page(1, 1).build();
        return (MdType)this.ezMapper.queryOne(query);
    }

    @Override
    public List<MdType> getByColumn(String column, Object value) {
        return this.getByColumn((Table)EntityTable.of(this.modelClass), column, value);
    }

    @Override
    public List<MdType> getByColumn(Table table, String column, Object value) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull((Object)column, (String)"column can not be null");
        Assert.notNull((Object)value, (String)"value can not be null");
        EzQuery query = ((EzQuery.EzQueryBuilder)((Where.WhereBuilder)((EzQuery.EzQueryBuilder)EzQuery.builder(this.modelClass).from(table).select().addAll(new String[0]).done()).where().addColumnCondition(column, value)).done()).build();
        return (List)this.ezMapper.queryOne(query);
    }

    @Override
    public MdType getOneByColumn(String column, Object value) {
        return this.getOneByColumn((Table)EntityTable.of(this.modelClass), column, value);
    }

    @Override
    public MdType getOneByColumn(Table table, String column, Object value) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull((Object)column, (String)"column can not be null");
        Assert.notNull((Object)value, (String)"value can not be null");
        EzQuery query = ((EzQuery.EzQueryBuilder)((Where.WhereBuilder)((EzQuery.EzQueryBuilder)EzQuery.builder(this.modelClass).from(table).select().addAll(new String[0]).done()).where().addColumnCondition(column, value)).done()).page(1, 1).build();
        return (MdType)this.ezMapper.queryOne(query);
    }

    @Override
    public int update(MdType model) {
        Assert.notNull(model, (String)"model can not be null");
        return this.ezMapper.update(model);
    }

    @Override
    public int update(Table table, MdType model) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull(model, (String)"model can not be null");
        return this.ezMapper.updateByTable(table, model);
    }

    @Override
    public int batchUpdate(Collection<MdType> models) {
        Assert.notEmpty(models, (String)"models can not be empty");
        return this.ezMapper.batchUpdate(models);
    }

    @Override
    public int batchUpdate(Table table, Collection<MdType> models) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notEmpty(models, (String)"models can not be empty");
        return this.ezMapper.batchUpdateByTable(table, models);
    }

    @Override
    public int replace(MdType model) {
        Assert.notNull(model, (String)"model can not be null");
        return this.ezMapper.replace(model);
    }

    @Override
    public int replace(Table table, MdType model) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull(model, (String)"model can not be null");
        return this.ezMapper.replaceByTable(table, model);
    }

    @Override
    public int batchReplace(Collection<MdType> models) {
        Assert.notEmpty(models, (String)"models can not be empty");
        return this.ezMapper.batchReplace(models);
    }

    @Override
    public int batchReplace(Table table, Collection<MdType> models) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notEmpty(models, (String)"models can not be empty");
        return this.ezMapper.batchReplaceByTable(table, models);
    }

    @Override
    public int deleteById(PkType id) {
        Assert.notNull(id, (String)"id can not be null");
        return this.ezMapper.deleteById(this.modelClass, id);
    }

    @Override
    public int deleteById(Table table, PkType id) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull(id, (String)"id can not be null");
        return this.ezMapper.deleteByTableAndId(table, this.modelClass, id);
    }

    @Override
    public int deleteByIds(Collection<PkType> ids) {
        Assert.notEmpty(ids, (String)"ids can not be null");
        return this.ezMapper.batchDeleteById(this.modelClass, ids);
    }

    @Override
    public int deleteByIds(Table table, Collection<PkType> ids) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notEmpty(ids, (String)"ids can not be null");
        return this.ezMapper.batchDeleteByTableAndId(table, this.modelClass, ids);
    }

    @Override
    public int deleteByField(String field, Object value) {
        return this.deleteByField((Table)EntityTable.of(this.modelClass), field, value);
    }

    @Override
    public int deleteByField(Table table, String field, Object value) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull((Object)field, (String)"field can not be null");
        Assert.notNull((Object)value, (String)"value can not be null");
        EzDelete delete = ((EzDelete.EzDeleteBuilder)((Where.WhereBuilder)EzDelete.delete((Table)table).where().addFieldCondition(field, value)).done()).build();
        return this.ezMapper.ezDelete(delete);
    }

    @Override
    public int deleteByColumn(String column, Object value) {
        return this.deleteByColumn((Table)EntityTable.of(this.modelClass), column, value);
    }

    @Override
    public int deleteByColumn(Table table, String column, Object value) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull((Object)column, (String)"column can not be null");
        Assert.notNull((Object)value, (String)"value can not be null");
        EzDelete delete = ((EzDelete.EzDeleteBuilder)((Where.WhereBuilder)EzDelete.delete((Table)table).where().addColumnCondition(column, value)).done()).build();
        return this.ezMapper.ezDelete(delete);
    }

    @Override
    public int delete(MdType model) {
        Assert.notNull(model, (String)"model can not be null");
        return this.ezMapper.delete(model);
    }

    @Override
    public int delete(Table table, MdType model) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull(model, (String)"model can not be null");
        return this.ezMapper.deleteByTable(table, model);
    }

    @Override
    public int batchDelete(Collection<MdType> models) {
        Assert.notEmpty(models, (String)"models can not be empty");
        return this.ezMapper.batchDelete(models);
    }

    @Override
    public int batchDelete(Table table, Collection<MdType> models) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notEmpty(models, (String)"models can not be empty");
        return this.ezMapper.batchDeleteByTable(table, models);
    }

    @Override
    public int save(MdType model) {
        Assert.notNull(model, (String)"model can not be empty");
        return this.ezMapper.insert(model);
    }

    @Override
    public int save(Table table, MdType model) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notNull(model, (String)"model can not be empty");
        return this.ezMapper.insertByTable(table, model);
    }

    @Override
    public int batchSave(Collection<MdType> models) {
        Assert.notEmpty(models, (String)"models can not be empty");
        return this.ezMapper.batchInsert(models);
    }

    @Override
    public int batchSave(Table table, Collection<MdType> models) {
        Assert.notNull((Object)table, (String)"table can not be null");
        Assert.notEmpty(models, (String)"models can not be empty");
        return this.ezMapper.batchInsertByTable(table, models);
    }
}

