/*
 * Decompiled with CFR 0.152.
 */
package org.rdlinux.ezsecurity.spring.boot.autoconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SubjectFactory;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.rdlinux.ezsecurity.ResponseRetConvert;
import org.rdlinux.ezsecurity.shiro.content.EzSecurityContent;
import org.rdlinux.ezsecurity.shiro.holder.ErrorConstantHolder;
import org.rdlinux.ezsecurity.shiro.redis.cache.ShiroRedisCacheManager;
import org.rdlinux.ezsecurity.shiro.security.client.AuthClient;
import org.rdlinux.ezsecurity.shiro.security.client.ClientHolder;
import org.rdlinux.ezsecurity.shiro.security.filter.CorsFilter;
import org.rdlinux.ezsecurity.shiro.security.filter.CunstomRolesAuthorizationFilter;
import org.rdlinux.ezsecurity.shiro.security.filter.CustomFormAuthenticationFilter;
import org.rdlinux.ezsecurity.shiro.security.filter.CustomPermissionsAuthorizationFilter;
import org.rdlinux.ezsecurity.shiro.security.filter.HeartbeatRequestFilter;
import org.rdlinux.ezsecurity.shiro.security.filter.LoginFilter;
import org.rdlinux.ezsecurity.shiro.security.filter.LogoutFilter;
import org.rdlinux.ezsecurity.shiro.security.filter.RedirectionFilter;
import org.rdlinux.ezsecurity.shiro.security.interceptor.CustomAuthorizationAttributeSourceAdvisor;
import org.rdlinux.ezsecurity.shiro.security.realm.SecurityRealm;
import org.rdlinux.ezsecurity.shiro.security.rootfilter.secutirylogic.SecurityLogic;
import org.rdlinux.ezsecurity.shiro.security.rootfilter.secutirylogic.impl.DefaultSecurityLogic;
import org.rdlinux.ezsecurity.shiro.security.session.DefaultSessionKeyStore;
import org.rdlinux.ezsecurity.shiro.security.session.RedisSessionKeyStore;
import org.rdlinux.ezsecurity.shiro.security.session.SecurityShiroRedisSessionDAO;
import org.rdlinux.ezsecurity.shiro.security.session.SecurityWebSessionManager;
import org.rdlinux.ezsecurity.shiro.security.session.SessionKeyStore;
import org.rdlinux.ezsecurity.shiro.spring.ShiroFilterFactoryBean;
import org.rdlinux.ezsecurity.spring.boot.autoconfig.EzSecurityConfigurationAdvice;
import org.rdlinux.ezsecurity.spring.boot.autoconfig.EzSecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.lang.NonNull;

@Configuration
@ConditionalOnClass(value={EzSecurityProperties.class})
@EnableConfigurationProperties(value={EzSecurityProperties.class})
public class EzSecurityAutoConfiguration
implements BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(EzSecurityAutoConfiguration.class);
    private final EzSecurityProperties ezSecurityProperties;
    private BeanFactory beanFactory;
    private List<AuthClient> clients;
    private RedisTemplate<Serializable, Object> redisTemplate;

    public EzSecurityAutoConfiguration(EzSecurityProperties ezSecurityProperties) {
        this.ezSecurityProperties = ezSecurityProperties;
    }

    private EzSecurityConfigurationAdvice getConfigurationAdvice() {
        try {
            return (EzSecurityConfigurationAdvice)this.beanFactory.getBean(EzSecurityConfigurationAdvice.class);
        }
        catch (BeansException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.initRedisTemplate();
        this.initEzSecurityContent();
    }

    private void initEzSecurityContent() {
        final EzSecurityConfigurationAdvice configurationAdvice = this.getConfigurationAdvice();
        EzSecurityContent.setErrorConstantHolder((ErrorConstantHolder)new ErrorConstantHolder(){

            public int getUnAuthenticated() {
                return EzSecurityAutoConfiguration.this.ezSecurityProperties.getUnAuthenticatedCode();
            }

            public int getUnAuthorized() {
                return EzSecurityAutoConfiguration.this.ezSecurityProperties.getUnAuthorizedCode();
            }

            public String getErrorMsg(int code) {
                if (code == EzSecurityAutoConfiguration.this.ezSecurityProperties.getUnAuthenticatedCode()) {
                    return configurationAdvice.getUnAuthenticatedMsg();
                }
                return configurationAdvice.getUnAuthorizedMsg();
            }
        });
        EzSecurityContent.setResponseRetConvert((ResponseRetConvert)configurationAdvice.getResponseRetConvert());
    }

    public void initRedisTemplate() {
        RedisTemplate redisTemplate;
        RedisConnectionFactory connectionFactory;
        if (this.ezSecurityProperties.isEnableRedisCache() && this.beanFactory.containsBean("redisTemplate") && (connectionFactory = (redisTemplate = (RedisTemplate)this.beanFactory.getBean("redisTemplate", RedisTemplate.class)).getConnectionFactory()) != null) {
            RedisTemplate template = new RedisTemplate();
            template.setConnectionFactory(connectionFactory);
            template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
            template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
            template.afterPropertiesSet();
            this.redisTemplate = template;
        }
    }

    @PostConstruct
    public void init() {
        this.clients = new LinkedList<AuthClient>();
        this.clients = this.getConfigurationAdvice().getClients(this.clients);
        this.clients.sort(Comparator.comparingInt(AuthClient::getOrder));
    }

    @Bean
    public SessionKeyStore sessionKeyStore() {
        if (this.ezSecurityProperties.isEnableRedisCache()) {
            return new RedisSessionKeyStore(this.redisTemplate);
        }
        return new DefaultSessionKeyStore(this.ezSecurityProperties.getSessionTimeout() * 1000L);
    }

    @Bean
    public SecurityRealm securityRealm() {
        return new SecurityRealm(this.ezSecurityProperties.getCachePrefix());
    }

    @Bean
    public ClientHolder clientHolder() {
        AuthClient defaultAuthClient = null;
        String defaultAuthTypeName = this.ezSecurityProperties.getDefaultAuthType();
        if (defaultAuthTypeName == null || defaultAuthTypeName.isEmpty()) {
            defaultAuthTypeName = "EC_JWT_USER";
        }
        for (AuthClient client : this.clients) {
            if (!defaultAuthTypeName.equals(client.getAuthType())) continue;
            defaultAuthClient = client;
            break;
        }
        return new ClientHolder(defaultAuthClient, this.clients);
    }

    @Bean
    public SessionManager shiroSessionManage() {
        SecurityWebSessionManager shiroSessionManage = new SecurityWebSessionManager(this.sessionKeyStore(), this.clientHolder());
        if (this.ezSecurityProperties.isEnableRedisCache()) {
            shiroSessionManage.setSessionDAO((SessionDAO)new SecurityShiroRedisSessionDAO(this.redisTemplate, this.sessionKeyStore(), this.ezSecurityProperties.getCachePrefix()));
        }
        shiroSessionManage.setGlobalSessionTimeout(this.ezSecurityProperties.getSessionTimeout() * 1000L);
        SimpleCookie simpleCookie = new SimpleCookie();
        simpleCookie.setName("shrio-sesssion-id");
        simpleCookie.setPath("/");
        shiroSessionManage.setSessionIdCookie((Cookie)simpleCookie);
        shiroSessionManage.setSessionValidationSchedulerEnabled(this.ezSecurityProperties.getEnableSession().booleanValue());
        return shiroSessionManage;
    }

    @Bean
    public SecurityManager shiroSecurityManager() {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        ArrayList<SecurityRealm> realms = new ArrayList<SecurityRealm>(3);
        realms.add(this.securityRealm());
        securityManager.setRealms(realms);
        securityManager.setSessionManager(this.shiroSessionManage());
        if (this.ezSecurityProperties.isEnableRedisCache()) {
            securityManager.setCacheManager((CacheManager)new ShiroRedisCacheManager(this.redisTemplate, this.ezSecurityProperties.getCacheTimeout() * 1000L));
        }
        securityManager.setSubjectFactory((SubjectFactory)new DefaultWebSubjectFactory(){

            public Subject createSubject(SubjectContext context) {
                context.setSessionCreationEnabled(EzSecurityAutoConfiguration.this.ezSecurityProperties.getEnableSession().booleanValue());
                return super.createSubject(context);
            }
        });
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
        DefaultSubjectDAO subjectDAO = (DefaultSubjectDAO)securityManager.getSubjectDAO();
        DefaultSessionStorageEvaluator sessionStorageEvaluator = (DefaultSessionStorageEvaluator)subjectDAO.getSessionStorageEvaluator();
        sessionStorageEvaluator.setSessionStorageEnabled(this.ezSecurityProperties.getEnableSession().booleanValue());
        return securityManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        CustomAuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new CustomAuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    @Bean
    public FilterRegistrationBean delegatingFilterProxy() throws Exception {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setLoginUrl(this.ezSecurityProperties.getLoginUrl());
        shiroFilterFactoryBean.setUnauthorizedUrl(null);
        shiroFilterFactoryBean.setSuccessUrl(null);
        shiroFilterFactoryBean.setSecurityManager(this.shiroSecurityManager());
        DefaultSecurityLogic securityLogic = new DefaultSecurityLogic();
        securityLogic.setEnableSession(this.ezSecurityProperties.getEnableSession().booleanValue());
        securityLogic.setClientHolder(this.clientHolder());
        securityLogic.setSessionKeyStore(this.sessionKeyStore());
        shiroFilterFactoryBean.setSecurityLogic((SecurityLogic)securityLogic);
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("origin", new CorsFilter());
        filters.put("cors", new CorsFilter());
        filters.put("heartbeat", new HeartbeatRequestFilter());
        filters.put("redirection", new RedirectionFilter(this.ezSecurityProperties.getRedirections()));
        LogoutFilter logoutFilter = new LogoutFilter();
        filters.put("logout", logoutFilter);
        LoginFilter loginFilter = new LoginFilter();
        filters.put("login", loginFilter);
        filters.put("authc", new CustomFormAuthenticationFilter());
        filters.put("roles", new CunstomRolesAuthorizationFilter());
        filters.put("perms", new CustomPermissionsAuthorizationFilter());
        Map<String, Filter> customFilters = this.getConfigurationAdvice().getFilters();
        if (customFilters != null && !customFilters.isEmpty()) {
            filters.putAll(customFilters);
        }
        shiroFilterFactoryBean.setFilters(filters);
        if (log.isDebugEnabled()) {
            log.debug(String.format("\u914d\u7f6e\u62e6\u622a\u5668\u7684url:%s", this.ezSecurityProperties.getFilterChainDefinitions()));
        }
        shiroFilterFactoryBean.setFilterChainDefinitionMap(this.ezSecurityProperties.getFilterChainDefinitions());
        shiroFilterFactoryBean.setExceptionHandler(this.getConfigurationAdvice().getShiroFilterExceptionHandler());
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)Objects.requireNonNull(shiroFilterFactoryBean.getObject()));
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        filterRegistrationBean.setName("ezSecurityFilter");
        filterRegistrationBean.setOrder(this.ezSecurityProperties.getRootFilterOrder());
        filterRegistrationBean.setEnabled(true);
        return filterRegistrationBean;
    }
}

