/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit.config;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.beans.ConstructorProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import org.reactivecommons.async.commons.config.BrokerConfig;
import org.reactivecommons.async.commons.config.IBrokerConfigProps;
import org.reactivecommons.async.commons.converters.MessageConverter;
import org.reactivecommons.async.commons.reply.ReactiveReplyRouter;
import org.reactivecommons.async.rabbit.RabbitDirectAsyncGateway;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageListener;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageSender;
import org.reactivecommons.async.rabbit.config.RabbitMqConfig;
import org.reactivecommons.async.rabbit.config.props.AsyncProps;
import org.reactivecommons.async.rabbit.listeners.ApplicationReplyListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={RabbitMqConfig.class})
public class DirectAsyncGatewayConfig {
    @Generated
    private static final Logger log = Logger.getLogger(DirectAsyncGatewayConfig.class.getName());
    private final IBrokerConfigProps brokerConfigProps;

    @Bean
    public RabbitDirectAsyncGateway rabbitDirectAsyncGateway(BrokerConfig config, ReactiveReplyRouter router, ReactiveMessageSender rSender, MessageConverter converter, MeterRegistry meterRegistry) {
        return new RabbitDirectAsyncGateway(config, router, rSender, this.brokerConfigProps.getDirectMessagesExchangeName(), converter, meterRegistry);
    }

    @Bean
    public ApplicationReplyListener msgListener(ReactiveReplyRouter router, BrokerConfig config, AsyncProps asyncProps, ReactiveMessageListener listener) {
        if (!asyncProps.isListenReplies()) {
            log.log(Level.WARNING, "ApplicationReplyListener is disabled in AsyncProps or app.async.listenReplies");
            return null;
        }
        ApplicationReplyListener replyListener = new ApplicationReplyListener(router, listener, this.brokerConfigProps.getReplyQueue(), this.brokerConfigProps.getGlobalReplyExchangeName(), asyncProps.getCreateTopology().booleanValue());
        replyListener.startListening(config.getRoutingKey());
        return replyListener;
    }

    @Bean
    public ReactiveReplyRouter router() {
        return new ReactiveReplyRouter();
    }

    @Bean
    @ConditionalOnMissingBean(value={MeterRegistry.class})
    public MeterRegistry defaultRabbitMeterRegistry() {
        return new SimpleMeterRegistry();
    }

    @ConstructorProperties(value={"brokerConfigProps"})
    @Generated
    public DirectAsyncGatewayConfig(IBrokerConfigProps brokerConfigProps) {
        this.brokerConfigProps = brokerConfigProps;
    }
}

