/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit.config;

import org.reactivecommons.api.domain.DomainEventBus;
import org.reactivecommons.async.commons.config.BrokerConfig;
import org.reactivecommons.async.commons.config.IBrokerConfigProps;
import org.reactivecommons.async.rabbit.RabbitDomainEventBus;
import org.reactivecommons.async.rabbit.communications.ReactiveMessageSender;
import org.reactivecommons.async.rabbit.config.RabbitMqConfig;
import org.reactivecommons.async.rabbit.config.props.AsyncProps;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import reactor.rabbitmq.ExchangeSpecification;

@Configuration
@Import(value={RabbitMqConfig.class})
public class EventBusConfig {
    @Bean
    public DomainEventBus domainEventBus(ReactiveMessageSender sender, IBrokerConfigProps props, AsyncProps asyncProps, BrokerConfig config) {
        String exchangeName = props.getDomainEventsExchangeName();
        if (asyncProps.getCreateTopology().booleanValue()) {
            sender.getTopologyCreator().declare(ExchangeSpecification.exchange((String)exchangeName).durable(true).type("topic")).subscribe();
        }
        return new RabbitDomainEventBus(sender, exchangeName, config);
    }
}

