/*
 * Decompiled with CFR 0.152.
 */
package org.reactivecommons.async.rabbit.config.props;

import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.reactivecommons.async.commons.config.IBrokerConfigProps;
import org.reactivecommons.async.commons.utils.NameGenerator;
import org.reactivecommons.async.rabbit.config.props.AsyncProps;
import org.springframework.beans.factory.annotation.Value;

public class BrokerConfigProps
implements IBrokerConfigProps {
    private final String appName;
    private final AsyncProps asyncProps;
    private final AtomicReference<String> replyQueueName = new AtomicReference();
    private final AtomicReference<String> notificationsQueueName = new AtomicReference();

    public BrokerConfigProps(@Value(value="${spring.application.name}") String appName, AsyncProps asyncProps) {
        this.appName = appName;
        this.asyncProps = asyncProps;
    }

    public String getEventsQueue() {
        return NameGenerator.fromNameWithSuffix((String)this.getAppName(), (String)this.asyncProps.getDomain().getEvents().getEventsSuffix());
    }

    public String getNotificationsQueue() {
        return this.resolveTemporaryQueue(this.notificationsQueueName, this.asyncProps.getDomain().getEvents().getNotificationSuffix());
    }

    public String getQueriesQueue() {
        return NameGenerator.fromNameWithSuffix((String)this.getAppName(), (String)this.asyncProps.getDirect().getQuerySuffix());
    }

    public String getCommandsQueue() {
        return NameGenerator.fromNameWithSuffix((String)this.getAppName(), (String)this.asyncProps.getDirect().getCommandSuffix());
    }

    public String getReplyQueue() {
        return this.resolveTemporaryQueue(this.replyQueueName, this.asyncProps.getGlobal().getRepliesSuffix());
    }

    public String getDomainEventsExchangeName() {
        return this.asyncProps.getDomain().getEvents().getExchange();
    }

    public String getDirectMessagesExchangeName() {
        return this.asyncProps.getDirect().getExchange();
    }

    public String getGlobalReplyExchangeName() {
        return this.asyncProps.getGlobal().getExchange();
    }

    private String resolveTemporaryQueue(AtomicReference<String> property, String suffix) {
        String name = property.get();
        if (name == null) {
            String replyName = NameGenerator.generateNameFrom((String)this.getAppName(), (String)suffix);
            if (property.compareAndSet(null, replyName)) {
                return replyName;
            }
            return property.get();
        }
        return name;
    }

    @Generated
    public String getAppName() {
        return this.appName;
    }

    @Generated
    public AsyncProps getAsyncProps() {
        return this.asyncProps;
    }

    @Generated
    public AtomicReference<String> getReplyQueueName() {
        return this.replyQueueName;
    }

    @Generated
    public AtomicReference<String> getNotificationsQueueName() {
        return this.notificationsQueueName;
    }
}

